# Λꜱᴛʀᴏɴɪx ʀᴇᴀʟᴛʏ - AI-Powered Real Estate Platform

A modern real estate platform built with React, TypeScript, and Tailwind CSS. Λꜱᴛʀᴏɴɪx ʀᴇᴀʟᴛʏ connects buyers with premium properties from trusted builders using AI-powered recommendations.

## Features

- 🏠 Property listings with detailed information
- 🤖 AI-powered property recommendations
- 💬 WhatsApp AI assistant integration
- 🏢 Builder dashboard and management
- 👥 Buyer dashboard with personalized recommendations
- 🔍 Advanced search and filtering
- 📱 Fully responsive design

## Technologies

This project is built with:

- **Vite** - Fast build tool and dev server
- **TypeScript** - Type-safe JavaScript
- **React** - UI library
- **shadcn-ui** - Beautiful component library
- **Tailwind CSS** - Utility-first CSS framework
- **Framer Motion** - Animation library
- **React Router** - Routing
- **TanStack Query** - Data fetching

## Getting Started

### Prerequisites

- Node.js (v18 or higher)
- npm or yarn

### Installation

1. Clone the repository:
```sh
git clone <YOUR_GIT_URL>
cd real-estate-akshay-main
```

2. Install dependencies:
```sh
npm install
```

3. Start the development server:
```sh
npm run dev
```

The application will be available at `http://localhost:8080`

## Available Scripts

- `npm run dev` - Start development server
- `npm run build` - Build for production
- `npm run build:dev` - Build for development
- `npm run preview` - Preview production build
- `npm run lint` - Run ESLint
- `npm test` - Run tests
- `npm run test:watch` - Run tests in watch mode

## Project Structure

```
src/
├── components/     # React components
│   ├── home/      # Home page components
│   ├── layout/    # Layout components (Navbar, Footer)
│   └── ui/        # Reusable UI components
├── pages/         # Page components
├── hooks/         # Custom React hooks
├── lib/           # Utility functions
└── assets/        # Static assets
```

## Deployment

Build the project for production:

```sh
npm run build
```

The built files will be in the `dist` directory, ready to be deployed to any static hosting service.

## License

Private project - All rights reserved
