import { motion } from "framer-motion";
import { 
  Bot, 
  MessageSquare, 
  Sparkles, 
  TrendingUp, 
  FileText, 
  Share2,
  Zap,
  Brain
} from "lucide-react";
import { Button } from "@/components/ui/button";

const features = [
  {
    icon: Bot,
    title: "WhatsApp AI Agent",
    description: "24/7 intelligent assistant that answers property queries, schedules visits, and handles follow-ups automatically.",
    color: "from-green-500 to-emerald-600",
  },
  {
    icon: Sparkles,
    title: "Smart Recommendations",
    description: "AI analyzes your preferences and budget to suggest perfectly matched properties from our extensive catalog.",
    color: "from-gold to-amber-600",
  },
  {
    icon: FileText,
    title: "Auto Content Generation",
    description: "AI creates SEO-optimized property descriptions, blog posts, and marketing content instantly.",
    color: "from-blue-500 to-indigo-600",
  },
  {
    icon: Share2,
    title: "Social Media Automation",
    description: "Automatically publish property listings across Instagram, Facebook, LinkedIn with optimized content.",
    color: "from-purple-500 to-pink-600",
  },
];

export function AIFeatures() {
  return (
    <section className="py-20 lg:py-32 relative overflow-hidden">
      {/* Background */}
      <div className="absolute inset-0 gradient-navy" />
      <div className="absolute inset-0 opacity-30">
        <div className="absolute top-0 left-1/4 w-96 h-96 bg-gold/20 rounded-full blur-3xl" />
        <div className="absolute bottom-0 right-1/4 w-96 h-96 bg-blue-500/20 rounded-full blur-3xl" />
      </div>

      <div className="mx-4 relative z-10">
        <div className="max-w-7xl mx-auto px-6">
        {/* Header */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          className="text-center mb-16 space-y-4"
        >
          <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white/10 border border-white/20">
            <Brain className="w-4 h-4 text-gold" />
            <span className="text-sm font-medium text-cream">Powered by AI</span>
          </div>
          <h2 className="text-3xl lg:text-5xl font-bold text-cream">
            Automation That Works
            <span className="block text-gradient-gold">While You Sleep</span>
          </h2>
          <p className="text-cream/70 max-w-2xl mx-auto">
            Our AI-powered platform handles lead generation, content creation, and customer engagement 
            automatically, so you can focus on closing deals.
          </p>
        </motion.div>

        {/* Features Grid */}
        <div className="grid md:grid-cols-2 gap-6 mb-16">
          {features.map((feature, index) => (
            <motion.div
              key={feature.title}
              initial={{ opacity: 0, y: 30 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              transition={{ delay: index * 0.1 }}
              className="group relative bg-white/5 backdrop-blur-xl rounded-2xl p-8 border border-white/10 hover:border-gold/30 transition-all duration-300"
            >
              <div className={`w-14 h-14 rounded-xl bg-gradient-to-br ${feature.color} flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300`}>
                <feature.icon className="w-7 h-7 text-white" />
              </div>
              <h3 className="text-xl font-semibold text-cream mb-3">{feature.title}</h3>
              <p className="text-cream/60 leading-relaxed">{feature.description}</p>
            </motion.div>
          ))}
        </div>

        {/* Demo Chat */}
        <motion.div
          initial={{ opacity: 0, scale: 0.95 }}
          whileInView={{ opacity: 1, scale: 1 }}
          viewport={{ once: true }}
          className="max-w-lg mx-auto"
        >
          <div className="bg-white/10 backdrop-blur-xl rounded-2xl p-6 border border-white/20">
            <div className="flex items-center gap-3 mb-6 pb-4 border-b border-white/10">
              <div className="w-10 h-10 rounded-full gradient-gold flex items-center justify-center">
                <Bot className="w-5 h-5 text-navy" />
              </div>
              <div>
                <div className="font-semibold text-cream">Λꜱᴛʀᴏɴɪx ʀᴇᴀʟᴛʏ AI</div>
                <div className="text-xs text-cream/60 flex items-center gap-1">
                  <span className="w-2 h-2 rounded-full bg-green-500" />
                  Online
                </div>
              </div>
            </div>

            <div className="space-y-4 mb-6">
              <div className="flex justify-end">
                <div className="bg-gold/20 text-cream px-4 py-2 rounded-2xl rounded-br-md max-w-[80%]">
                  Looking for 3BHK in Mumbai under 2 crore
                </div>
              </div>
              <div className="flex justify-start">
                <div className="bg-white/10 text-cream px-4 py-3 rounded-2xl rounded-bl-md max-w-[80%]">
                  <p className="mb-2">I found 12 perfect matches for you! 🏠</p>
                  <p className="text-cream/70 text-sm">
                    Top recommendation: Godrej Sky Gardens, Worli - ₹1.8 Cr. 
                    Would you like to schedule a site visit?
                  </p>
                </div>
              </div>
            </div>

            <div className="flex gap-2">
              <input
                type="text"
                placeholder="Ask about any property..."
                className="flex-1 bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-cream placeholder:text-cream/40 focus:outline-none focus:border-gold/50"
              />
              <Button variant="gold">
                <Zap className="w-5 h-5" />
              </Button>
            </div>
          </div>
        </motion.div>
        </div>
      </div>
    </section>
  );
}
