import { motion } from "framer-motion";
import { ArrowRight, MessageCircle, Phone, Mail } from "lucide-react";
import { Button } from "@/components/ui/button";

export function CTASection() {
  return (
    <section id="contact" className="py-20 lg:py-32">
      <div className="mx-4">
        <div className="max-w-7xl mx-auto px-6">
        <motion.div
          initial={{ opacity: 0, y: 30 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          className="relative rounded-3xl overflow-hidden"
        >
          {/* Background */}
          <div className="absolute inset-0 gradient-navy" />
          <div className="absolute inset-0">
            <div className="absolute top-0 right-0 w-96 h-96 bg-gold/20 rounded-full blur-3xl" />
            <div className="absolute bottom-0 left-0 w-64 h-64 bg-blue-500/20 rounded-full blur-3xl" />
          </div>

          <div className="relative z-10 px-8 py-16 lg:px-16 lg:py-24">
            <div className="grid lg:grid-cols-2 gap-12 items-center">
              {/* Content */}
              <div className="space-y-6">
                <h2 className="text-3xl lg:text-5xl font-bold text-cream leading-tight">
                  Ready to Find Your
                  <span className="block text-gradient-gold">Dream Property?</span>
                </h2>
                <p className="text-lg text-cream/70 max-w-md">
                  Our AI-powered platform and expert team are ready to help you make the best 
                  real estate decision of your life.
                </p>
                <div className="flex flex-wrap gap-4">
                  <Button variant="gold" size="xl">
                    Get Started Free
                    <ArrowRight className="w-5 h-5" />
                  </Button>
                  <Button variant="glass" size="xl" className="text-cream border-white/20">
                    <Phone className="w-5 h-5" />
                    Talk to Expert
                  </Button>
                </div>
              </div>

              {/* Contact Cards */}
              <div className="grid sm:grid-cols-2 gap-4">
                <motion.a
                  href="https://wa.me/919999999999"
                  whileHover={{ scale: 1.02 }}
                  className="bg-white/10 backdrop-blur-lg rounded-2xl p-6 border border-white/10 hover:border-green-500/50 transition-colors group"
                >
                  <div className="w-12 h-12 rounded-xl bg-green-500 flex items-center justify-center mb-4">
                    <MessageCircle className="w-6 h-6 text-white" />
                  </div>
                  <h3 className="text-lg font-semibold text-cream mb-1">WhatsApp</h3>
                  <p className="text-cream/60 text-sm">Chat with AI instantly</p>
                </motion.a>

                <motion.a
                  href="tel:+919999999999"
                  whileHover={{ scale: 1.02 }}
                  className="bg-white/10 backdrop-blur-lg rounded-2xl p-6 border border-white/10 hover:border-gold/50 transition-colors group"
                >
                  <div className="w-12 h-12 rounded-xl gradient-gold flex items-center justify-center mb-4">
                    <Phone className="w-6 h-6 text-navy" />
                  </div>
                  <h3 className="text-lg font-semibold text-cream mb-1">Call Us</h3>
                  <p className="text-cream/60 text-sm">+91 99999 99999</p>
                </motion.a>

                <motion.a
                  href="mailto:hello@astronixrealty.com"
                  whileHover={{ scale: 1.02 }}
                  className="sm:col-span-2 bg-white/10 backdrop-blur-lg rounded-2xl p-6 border border-white/10 hover:border-blue-500/50 transition-colors group"
                >
                  <div className="flex items-center gap-4">
                    <div className="w-12 h-12 rounded-xl bg-blue-500 flex items-center justify-center">
                      <Mail className="w-6 h-6 text-white" />
                    </div>
                    <div>
                      <h3 className="text-lg font-semibold text-cream">Email Us</h3>
                      <p className="text-cream/60 text-sm">hello@astronixrealty.com</p>
                    </div>
                  </div>
                </motion.a>
              </div>
            </div>
          </div>
        </motion.div>
        </div>
      </div>
    </section>
  );
}
