import { motion } from "framer-motion";
import { ArrowRight, Filter, ChevronDown } from "lucide-react";
import { Button } from "@/components/ui/button";
import { PropertyCard } from "./PropertyCard";
import property1 from "@/assets/property-1.jpg";
import property2 from "@/assets/property-2.jpg";
import property3 from "@/assets/property-3.jpg";

const properties = [
  {
    image: property1,
    title: "Prestige Ocean View",
    location: "Bandra West, Mumbai",
    price: "₹4.5 Cr",
    beds: 4,
    baths: 3,
    sqft: "2,450 sqft",
    builder: "Prestige Group",
    isNew: true,
    isFeatured: true,
  },
  {
    image: property2,
    title: "Godrej Sky Gardens",
    location: "Worli, Mumbai",
    price: "₹3.2 Cr",
    beds: 3,
    baths: 2,
    sqft: "1,850 sqft",
    builder: "Godrej Properties",
    isNew: true,
  },
  {
    image: property3,
    title: "Lodha The Park",
    location: "Lower Parel, Mumbai",
    price: "₹2.8 Cr",
    beds: 3,
    baths: 2,
    sqft: "1,650 sqft",
    builder: "Lodha Group",
  },
  {
    image: property1,
    title: "Hiranandani Gardens",
    location: "Powai, Mumbai",
    price: "₹1.9 Cr",
    beds: 2,
    baths: 2,
    sqft: "1,200 sqft",
    builder: "Hiranandani",
  },
  {
    image: property2,
    title: "Oberoi Esquire",
    location: "Goregaon East, Mumbai",
    price: "₹2.2 Cr",
    beds: 3,
    baths: 2,
    sqft: "1,400 sqft",
    builder: "Oberoi Realty",
  },
];

const filters = ["All", "Apartments", "Villas", "Penthouses", "Plots"];

export function FeaturedProperties() {
  return (
    <section id="properties" className="py-20 lg:py-32 bg-secondary/50">
      <div className="mx-4">
        <div className="max-w-7xl mx-auto px-6">
        {/* Header */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          className="flex flex-col lg:flex-row lg:items-end lg:justify-between gap-6 mb-12"
        >
          <div className="space-y-4">
            <span className="text-sm font-semibold text-gold uppercase tracking-widest">
              Featured Listings
            </span>
            <h2 className="text-3xl lg:text-4xl font-bold text-navy">
              Discover Premium Properties
            </h2>
            <p className="text-muted-foreground max-w-xl">
              Handpicked luxury properties from India's most trusted builders. 
              Each listing is verified and ready for your dream home journey.
            </p>
          </div>

          <div className="flex flex-wrap items-center gap-3">
            {filters.map((filter, index) => (
              <button
                key={filter}
                className={`px-4 py-2 rounded-full text-sm font-medium transition-all duration-200 ${
                  index === 0
                    ? "gradient-gold text-navy shadow-gold"
                    : "bg-card text-muted-foreground hover:text-navy hover:bg-card/80"
                }`}
              >
                {filter}
              </button>
            ))}
            <Button variant="outline" size="sm" className="gap-2">
              <Filter className="w-4 h-4" />
              More Filters
              <ChevronDown className="w-4 h-4" />
            </Button>
          </div>
        </motion.div>

        {/* Properties Grid */}
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
          {properties.map((property, index) => (
            <PropertyCard key={property.title} {...property} index={index} />
          ))}
        </div>

        {/* CTA */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          className="text-center mt-12"
        >
          <Button variant="navy" size="xl">
            View All Properties
            <ArrowRight className="w-5 h-5" />
          </Button>
        </motion.div>
        </div>
      </div>
    </section>
  );
}
