import { motion } from "framer-motion";
import { ArrowRight, Play, MapPin, Home, TrendingUp, MessageCircle } from "lucide-react";
import { Button } from "@/components/ui/button";
import heroImage from "@/assets/hero-property.jpg";

const stats = [
  { value: "500+", label: "Premium Properties", icon: Home },
  { value: "50+", label: "Trusted Builders", icon: TrendingUp },
  { value: "10K+", label: "Happy Families", icon: MapPin },
];

export function HeroSection() {
  return (
    <section className="relative min-h-screen flex items-center justify-center pt-32 pb-20 overflow-hidden">
      {/* Background Pattern */}
      <div className="absolute inset-0 bg-[radial-gradient(ellipse_at_top_right,_var(--tw-gradient-stops))] from-gold/5 via-transparent to-transparent" />
      <div className="absolute top-20 right-0 w-[600px] h-[600px] bg-gold/10 rounded-full blur-3xl" />
      <div className="absolute bottom-0 left-0 w-[400px] h-[400px] bg-navy/5 rounded-full blur-3xl" />

      <div className="mx-4 relative z-10 w-full">
        <div className="max-w-7xl mx-auto px-6">
          <div className="grid lg:grid-cols-2 gap-12 lg:gap-20 items-center justify-items-center">
          {/* Left Content */}
          <motion.div
            initial={{ opacity: 0, x: -50 }}
            animate={{ opacity: 1, x: 0 }}
            transition={{ duration: 0.8, ease: "easeOut" }}
            className="space-y-8 w-full"
          >
            {/* Badge */}
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.2 }}
              className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-gold/10 border border-gold/20"
            >
              <span className="w-2 h-2 rounded-full bg-gold animate-pulse" />
              <span className="text-sm font-medium text-navy">AI-Powered Real Estate Platform</span>
            </motion.div>

            {/* Headline */}
            <div className="space-y-4">
              <h1 className="text-4xl sm:text-5xl lg:text-6xl font-bold text-navy leading-[1.1]">
                Find Your
                <span className="block text-gradient-gold">Dream Property</span>
                With AI Precision
              </h1>
              <p className="text-lg text-muted-foreground max-w-xl leading-relaxed">
                Experience the future of real estate. Our AI-powered platform connects you with premium properties 
                from trusted builders, with intelligent recommendations tailored just for you.
              </p>
            </div>

            {/* Search Bar */}
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.4 }}
              className="glass-card p-2 rounded-2xl max-w-xl"
            >
              <div className="flex items-center gap-2">
                <div className="flex-1 flex items-center gap-3 px-4">
                  <MapPin className="w-5 h-5 text-gold" />
                  <input
                    type="text"
                    placeholder="Search by location, builder, or property..."
                    className="flex-1 bg-transparent border-none outline-none text-navy placeholder:text-muted-foreground py-3"
                  />
                </div>
                <Button variant="gold" size="lg" className="rounded-xl">
                  Search
                  <ArrowRight className="w-4 h-4" />
                </Button>
              </div>
            </motion.div>

            {/* CTA Buttons */}
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.5 }}
              className="flex flex-wrap items-center gap-4"
            >
              <Button variant="whatsapp" size="lg">
                <MessageCircle className="w-5 h-5" />
                Chat on WhatsApp
              </Button>
              <Button variant="navy-outline" size="lg">
                <Play className="w-4 h-4" />
                Watch How It Works
              </Button>
            </motion.div>

            {/* Stats */}
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.6 }}
              className="flex flex-wrap gap-8 pt-4"
            >
              {stats.map((stat, index) => (
                <div key={stat.label} className="flex items-center gap-3">
                  <div className="w-12 h-12 rounded-xl bg-secondary flex items-center justify-center">
                    <stat.icon className="w-5 h-5 text-gold" />
                  </div>
                  <div>
                    <div className="text-2xl font-bold text-navy">{stat.value}</div>
                    <div className="text-sm text-muted-foreground">{stat.label}</div>
                  </div>
                </div>
              ))}
            </motion.div>
          </motion.div>

          {/* Right Image */}
          <motion.div
            initial={{ opacity: 0, scale: 0.9 }}
            animate={{ opacity: 1, scale: 1 }}
            transition={{ duration: 0.8, delay: 0.3 }}
            className="relative"
          >
            <div className="relative rounded-3xl overflow-hidden shadow-2xl">
              <img
                src={heroImage}
                alt="Luxury Property"
                className="w-full h-[500px] lg:h-[600px] object-cover"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-navy/60 via-transparent to-transparent" />
              
              {/* Floating Cards */}
              <motion.div
                initial={{ opacity: 0, x: -20 }}
                animate={{ opacity: 1, x: 0 }}
                transition={{ delay: 0.8 }}
                className="absolute bottom-6 left-6 right-6 glass-card rounded-2xl p-4"
              >
                <div className="flex items-center justify-between">
                  <div>
                    <h3 className="text-lg font-semibold text-navy">Skyline Residences</h3>
                    <p className="text-sm text-muted-foreground">Mumbai, Maharashtra</p>
                  </div>
                  <div className="text-right">
                    <div className="text-lg font-bold text-gold">₹2.5 Cr</div>
                    <div className="text-xs text-muted-foreground">Starting Price</div>
                  </div>
                </div>
              </motion.div>

              {/* AI Badge */}
              <motion.div
                initial={{ opacity: 0, y: -20 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ delay: 1 }}
                className="absolute top-6 right-6 glass-card rounded-xl px-4 py-2"
              >
                <div className="flex items-center gap-2">
                  <div className="w-2 h-2 rounded-full bg-green-500 animate-pulse" />
                  <span className="text-sm font-medium text-navy">AI Assistant Online</span>
                </div>
              </motion.div>
            </div>

            {/* Decorative Elements */}
            <div className="absolute -top-4 -right-4 w-24 h-24 rounded-2xl gradient-gold opacity-20 blur-2xl" />
            <div className="absolute -bottom-4 -left-4 w-32 h-32 rounded-2xl bg-navy opacity-10 blur-2xl" />
          </motion.div>
        </div>
        </div>
      </div>
    </section>
  );
}
