import { motion } from "framer-motion";
import { Star, Quote } from "lucide-react";

const testimonials = [
  {
    name: "Rajesh Kumar",
    role: "Homebuyer",
    location: "Mumbai",
    content: "Λꜱᴛʀᴏɴɪx ʀᴇᴀʟᴛʏ's AI assistant helped me find my dream home in just 2 weeks. The WhatsApp bot was incredibly helpful and responsive!",
    rating: 5,
    avatar: "RK",
  },
  {
    name: "Priya Sharma",
    role: "Property Investor",
    location: "Bangalore",
    content: "The platform's AI recommendations are spot-on. I've made 3 successful investments thanks to their market insights.",
    rating: 5,
    avatar: "PS",
  },
  {
    name: "Anil Mehta",
    role: "Builder Partner",
    location: "Prestige Group",
    content: "Our lead generation increased by 300% after partnering with Λꜱᴛʀᴏɴɪx ʀᴇᴀʟᴛʏ. The automation features save us countless hours.",
    rating: 5,
    avatar: "AM",
  },
];

export function Testimonials() {
  return (
    <section className="py-20 lg:py-32 bg-secondary/50">
      <div className="mx-4">
        <div className="max-w-7xl mx-auto px-6">
        {/* Header */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          className="text-center mb-16 space-y-4"
        >
          <span className="text-sm font-semibold text-gold uppercase tracking-widest">
            Success Stories
          </span>
          <h2 className="text-3xl lg:text-4xl font-bold text-navy">
            Loved by Thousands
          </h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            Join 10,000+ happy customers who found their perfect property through Λꜱᴛʀᴏɴɪx ʀᴇᴀʟᴛʏ.
          </p>
        </motion.div>

        {/* Testimonials Grid */}
        <div className="grid md:grid-cols-3 gap-6">
          {testimonials.map((testimonial, index) => (
            <motion.div
              key={testimonial.name}
              initial={{ opacity: 0, y: 30 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              transition={{ delay: index * 0.1 }}
              className="bg-card rounded-2xl p-8 hover-lift relative"
            >
              <Quote className="absolute top-6 right-6 w-10 h-10 text-gold/20" />
              
              {/* Rating */}
              <div className="flex gap-1 mb-6">
                {Array.from({ length: testimonial.rating }).map((_, i) => (
                  <Star key={i} className="w-5 h-5 text-gold fill-gold" />
                ))}
              </div>

              {/* Content */}
              <p className="text-foreground/80 mb-8 leading-relaxed">
                "{testimonial.content}"
              </p>

              {/* Author */}
              <div className="flex items-center gap-4">
                <div className="w-12 h-12 rounded-full gradient-gold flex items-center justify-center text-navy font-semibold">
                  {testimonial.avatar}
                </div>
                <div>
                  <div className="font-semibold text-navy">{testimonial.name}</div>
                  <div className="text-sm text-muted-foreground">
                    {testimonial.role} • {testimonial.location}
                  </div>
                </div>
              </div>
            </motion.div>
          ))}
        </div>
        </div>
      </div>
    </section>
  );
}
