import { motion } from "framer-motion";
import { Building2, CheckCircle2, Star, ArrowRight } from "lucide-react";
import { Button } from "@/components/ui/button";

const builders = [
  { name: "Prestige Group", projects: 120, rating: 4.9, verified: true },
  { name: "Godrej Properties", projects: 95, rating: 4.8, verified: true },
  { name: "Lodha Group", projects: 85, rating: 4.7, verified: true },
  { name: "Oberoi Realty", projects: 45, rating: 4.9, verified: true },
  { name: "Hiranandani", projects: 65, rating: 4.8, verified: true },
  { name: "Tata Housing", projects: 78, rating: 4.7, verified: true },
];

export function TrustedBuilders() {
  return (
    <section id="builders" className="py-20 lg:py-32">
      <div className="mx-4">
        <div className="max-w-7xl mx-auto px-6">
        {/* Header */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          className="text-center mb-16 space-y-4"
        >
          <span className="text-sm font-semibold text-gold uppercase tracking-widest">
            Trusted Partners
          </span>
          <h2 className="text-3xl lg:text-4xl font-bold text-navy">
            India's Leading Builders
          </h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            We partner exclusively with RERA-registered, trusted builders who have a proven track record 
            of delivering quality homes on time.
          </p>
        </motion.div>

        {/* Builders Grid */}
        <div className="grid sm:grid-cols-2 lg:grid-cols-3 gap-6">
          {builders.map((builder, index) => (
            <motion.div
              key={builder.name}
              initial={{ opacity: 0, y: 30 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              transition={{ delay: index * 0.1 }}
              className="group bg-card rounded-2xl p-6 hover-lift border border-border hover:border-gold/30 transition-colors duration-300"
            >
              <div className="flex items-start justify-between mb-4">
                <div className="w-14 h-14 rounded-xl bg-secondary flex items-center justify-center">
                  <Building2 className="w-7 h-7 text-gold" />
                </div>
                {builder.verified && (
                  <div className="flex items-center gap-1 text-xs font-medium text-green-600 bg-green-50 px-2 py-1 rounded-full">
                    <CheckCircle2 className="w-3 h-3" />
                    Verified
                  </div>
                )}
              </div>

              <h3 className="text-xl font-semibold text-navy mb-2 group-hover:text-gold transition-colors">
                {builder.name}
              </h3>

              <div className="flex items-center gap-4 text-sm text-muted-foreground mb-4">
                <span>{builder.projects}+ Projects</span>
                <div className="flex items-center gap-1">
                  <Star className="w-4 h-4 text-gold fill-gold" />
                  <span>{builder.rating}</span>
                </div>
              </div>

              <Button variant="ghost" className="w-full group-hover:bg-secondary">
                View Projects
                <ArrowRight className="w-4 h-4" />
              </Button>
            </motion.div>
          ))}
        </div>

        {/* Trust Badges */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          className="mt-16 glass-card rounded-2xl p-8"
        >
          <div className="grid sm:grid-cols-2 lg:grid-cols-4 gap-8">
            {[
              { value: "100%", label: "RERA Compliant" },
              { value: "50+", label: "Trusted Builders" },
              { value: "500+", label: "Verified Projects" },
              { value: "₹5000Cr+", label: "Property Value" },
            ].map((stat, index) => (
              <div key={stat.label} className="text-center">
                <div className="text-3xl lg:text-4xl font-bold text-gradient-gold mb-2">
                  {stat.value}
                </div>
                <div className="text-sm text-muted-foreground">{stat.label}</div>
              </div>
            ))}
          </div>
        </motion.div>
        </div>
      </div>
    </section>
  );
}
