import { useState } from "react";
import { motion, AnimatePresence } from "framer-motion";
import { MessageCircle, X, Send } from "lucide-react";
import { Button } from "@/components/ui/button";

export function WhatsAppWidget() {
  const [isOpen, setIsOpen] = useState(false);

  return (
    <div className="fixed bottom-6 right-6 z-50">
      <AnimatePresence>
        {isOpen && (
          <motion.div
            initial={{ opacity: 0, y: 20, scale: 0.9 }}
            animate={{ opacity: 1, y: 0, scale: 1 }}
            exit={{ opacity: 0, y: 20, scale: 0.9 }}
            className="absolute bottom-20 right-0 w-80 bg-card rounded-2xl shadow-2xl border border-border overflow-hidden"
          >
            {/* Header */}
            <div className="bg-[#25D366] p-4">
              <div className="flex items-center gap-3">
                <div className="w-10 h-10 rounded-full bg-white/20 flex items-center justify-center">
                  <MessageCircle className="w-5 h-5 text-white" />
                </div>
                <div>
                  <div className="font-semibold text-white">Λꜱᴛʀᴏɴɪx ʀᴇᴀʟᴛʏ AI</div>
                  <div className="text-xs text-white/80 flex items-center gap-1">
                    <span className="w-2 h-2 rounded-full bg-white" />
                    Online now
                  </div>
                </div>
              </div>
            </div>

            {/* Chat Area */}
            <div className="p-4 min-h-[200px] bg-[#e5ddd5] space-y-3">
              <div className="bg-white rounded-lg rounded-tl-none p-3 max-w-[85%] shadow-sm">
                <p className="text-sm text-gray-800">
                  👋 Hello! I'm your Λꜱᴛʀᴏɴɪx ʀᴇᴀʟᴛʏ AI assistant. How can I help you find your dream property today?
                </p>
                <span className="text-[10px] text-gray-500 mt-1 block text-right">Now</span>
              </div>
            </div>

            {/* Quick Actions */}
            <div className="p-4 bg-card border-t border-border">
              <p className="text-xs text-muted-foreground mb-3">Quick Questions:</p>
              <div className="flex flex-wrap gap-2 mb-4">
                <button className="text-xs px-3 py-1.5 rounded-full bg-secondary hover:bg-gold hover:text-navy transition-colors">
                  3BHK in Mumbai
                </button>
                <button className="text-xs px-3 py-1.5 rounded-full bg-secondary hover:bg-gold hover:text-navy transition-colors">
                  Under ₹2 Cr
                </button>
                <button className="text-xs px-3 py-1.5 rounded-full bg-secondary hover:bg-gold hover:text-navy transition-colors">
                  Schedule Visit
                </button>
              </div>
              <a
                href="https://wa.me/919999999999?text=Hi%2C%20I'm%20interested%20in%20properties"
                target="_blank"
                rel="noopener noreferrer"
                className="flex items-center justify-center gap-2 w-full py-3 rounded-xl bg-[#25D366] text-white font-medium hover:bg-[#20BD5A] transition-colors"
              >
                <Send className="w-4 h-4" />
                Start Chat on WhatsApp
              </a>
            </div>
          </motion.div>
        )}
      </AnimatePresence>

      {/* Toggle Button */}
      <motion.button
        whileHover={{ scale: 1.05 }}
        whileTap={{ scale: 0.95 }}
        onClick={() => setIsOpen(!isOpen)}
        className="w-14 h-14 rounded-full bg-[#25D366] text-white flex items-center justify-center shadow-lg hover:shadow-xl transition-shadow"
      >
        {isOpen ? (
          <X className="w-6 h-6" />
        ) : (
          <MessageCircle className="w-6 h-6" />
        )}
      </motion.button>

      {/* Pulse Animation */}
      {!isOpen && (
        <span className="absolute -top-1 -right-1 w-4 h-4 rounded-full bg-red-500 animate-pulse" />
      )}
    </div>
  );
}
