import { Building2, Facebook, Instagram, Linkedin, Twitter, Youtube } from "lucide-react";

const footerLinks = {
  company: [
    { label: "About Us", href: "#" },
    { label: "Careers", href: "#" },
    { label: "Press", href: "#" },
    { label: "Contact", href: "#" },
  ],
  properties: [
    { label: "Mumbai", href: "#" },
    { label: "Bangalore", href: "#" },
    { label: "Pune", href: "#" },
    { label: "Hyderabad", href: "#" },
  ],
  resources: [
    { label: "Blog", href: "#" },
    { label: "Guides", href: "#" },
    { label: "Market Insights", href: "#" },
    { label: "Calculator", href: "#" },
  ],
  legal: [
    { label: "Privacy Policy", href: "#" },
    { label: "Terms of Service", href: "#" },
    { label: "RERA Compliance", href: "#" },
  ],
};

const socialLinks = [
  { icon: Facebook, href: "#" },
  { icon: Instagram, href: "#" },
  { icon: Twitter, href: "#" },
  { icon: Linkedin, href: "#" },
  { icon: Youtube, href: "#" },
];

export function Footer() {
  return (
    <footer className="bg-navy text-cream/80">
      <div className="mx-4">
        <div className="max-w-7xl mx-auto px-6 py-16">
        <div className="grid md:grid-cols-2 lg:grid-cols-6 gap-12">
          {/* Brand */}
          <div className="lg:col-span-2 space-y-6">
            <a href="/" className="flex items-center gap-3">
              <div className="w-10 h-10 rounded-xl gradient-gold flex items-center justify-center shadow-gold">
                <Building2 className="w-5 h-5 text-navy" />
              </div>
              <div className="flex flex-col">
                <span className="text-xl font-bold text-cream tracking-tight">Λꜱᴛʀᴏɴɪx ʀᴇᴀʟᴛʏ</span>
                <span className="text-[10px] text-cream/50 uppercase tracking-widest">Premium Realty</span>
              </div>
            </a>
            <p className="text-cream/60 max-w-xs">
              India's most trusted AI-powered real estate platform. Find your dream property with precision and ease.
            </p>
            <div className="flex gap-4">
              {socialLinks.map((social, index) => (
                <a
                  key={index}
                  href={social.href}
                  className="w-10 h-10 rounded-lg bg-white/5 flex items-center justify-center hover:bg-gold hover:text-navy transition-colors duration-200"
                >
                  <social.icon className="w-5 h-5" />
                </a>
              ))}
            </div>
          </div>

          {/* Links */}
          <div>
            <h4 className="font-semibold text-cream mb-4">Company</h4>
            <ul className="space-y-3">
              {footerLinks.company.map((link) => (
                <li key={link.label}>
                  <a href={link.href} className="hover:text-gold transition-colors">
                    {link.label}
                  </a>
                </li>
              ))}
            </ul>
          </div>

          <div>
            <h4 className="font-semibold text-cream mb-4">Properties</h4>
            <ul className="space-y-3">
              {footerLinks.properties.map((link) => (
                <li key={link.label}>
                  <a href={link.href} className="hover:text-gold transition-colors">
                    {link.label}
                  </a>
                </li>
              ))}
            </ul>
          </div>

          <div>
            <h4 className="font-semibold text-cream mb-4">Resources</h4>
            <ul className="space-y-3">
              {footerLinks.resources.map((link) => (
                <li key={link.label}>
                  <a href={link.href} className="hover:text-gold transition-colors">
                    {link.label}
                  </a>
                </li>
              ))}
            </ul>
          </div>

          <div>
            <h4 className="font-semibold text-cream mb-4">Legal</h4>
            <ul className="space-y-3">
              {footerLinks.legal.map((link) => (
                <li key={link.label}>
                  <a href={link.href} className="hover:text-gold transition-colors">
                    {link.label}
                  </a>
                </li>
              ))}
            </ul>
          </div>
        </div>

        {/* Bottom */}
        <div className="mt-16 pt-8 border-t border-white/10 flex flex-col md:flex-row justify-between items-center gap-4">
          <p className="text-sm text-cream/50">
            © 2024 Λꜱᴛʀᴏɴɪx ʀᴇᴀʟᴛʏ. All rights reserved. RERA Registered.
          </p>
          <p className="text-sm text-cream/50">
            Developed by{" "}
            <a 
              href="https://www.codearya.com" 
              target="_blank" 
              rel="noopener noreferrer"
              className="text-gold hover:text-gold/80 transition-colors underline"
            >
              Codearya
            </a>
          </p>
        </div>
        </div>
      </div>
    </footer>
  );
}
