import { motion } from 'framer-motion';
import { Plus, FileText, Users, Settings } from 'lucide-react';

const actions = [
  { label: 'Add Institute', icon: Plus, variant: 'primary' },
  { label: 'View Reports', icon: FileText, variant: 'secondary' },
  { label: 'Manage Users', icon: Users, variant: 'primary' },
  { label: 'Settings', icon: Settings, variant: 'secondary' },
];

export function ActionsWidget() {
  return (
    <div className="glass-card p-5 h-full">
      <h3 className="font-display text-lg font-semibold text-foreground mb-4">Quick Actions</h3>
      
      <div className="grid grid-cols-2 gap-3">
        {actions.map((action, index) => {
          const Icon = action.icon;
          const isPrimary = action.variant === 'primary';
          
          return (
            <motion.button
              key={action.label}
              initial={{ opacity: 0, scale: 0.9 }}
              animate={{ opacity: 1, scale: 1 }}
              transition={{ delay: index * 0.05 }}
              whileHover={{ scale: 1.05 }}
              whileTap={{ scale: 0.95 }}
              className={`p-3 rounded-lg flex flex-col items-center gap-2 transition-all ${
                isPrimary
                  ? 'bg-primary/10 hover:bg-primary/20 text-primary'
                  : 'bg-secondary/10 hover:bg-secondary/20 text-secondary'
              }`}
            >
              <Icon size={20} />
              <span className="text-xs font-medium">{action.label}</span>
            </motion.button>
          );
        })}
      </div>
    </div>
  );
}
