import { motion } from 'framer-motion';
import { Calendar, ArrowRight } from 'lucide-react';

const events = [
  { title: 'System Maintenance', date: 'Jan 15, 2026', time: '2:00 AM' },
  { title: 'Quarterly Review', date: 'Jan 20, 2026', time: '10:00 AM' },
  { title: 'New Feature Release', date: 'Jan 25, 2026', time: '12:00 PM' },
];

export function EventsWidget() {
  return (
    <div className="glass-card p-5 h-full neon-border-cyan">
      <div className="flex items-center justify-between mb-4">
        <h3 className="font-display text-lg font-semibold text-foreground">Upcoming Events</h3>
        <div className="p-2 rounded-lg bg-primary/20">
          <Calendar size={18} className="text-primary" />
        </div>
      </div>
      
      <div className="space-y-3">
        {events.map((event, index) => (
          <motion.div
            key={event.title}
            initial={{ opacity: 0, x: -20 }}
            animate={{ opacity: 1, x: 0 }}
            transition={{ delay: index * 0.1 }}
            className="flex items-center justify-between p-3 rounded-lg bg-muted/50 hover:bg-muted transition-colors cursor-pointer group"
          >
            <div>
              <p className="text-sm font-medium text-foreground">{event.title}</p>
              <p className="text-xs text-muted-foreground">{event.date} • {event.time}</p>
            </div>
            <ArrowRight size={16} className="text-muted-foreground group-hover:text-primary transition-colors" />
          </motion.div>
        ))}
      </div>
    </div>
  );
}
