import { motion } from 'framer-motion';
import { Building2, ArrowRight } from 'lucide-react';

const institutes = [
  { name: 'Stanford Academy', students: 1250, status: 'active' },
  { name: 'MIT School of Tech', students: 980, status: 'active' },
  { name: 'Oxford Learning', students: 2100, status: 'pending' },
  { name: 'Harvard Prep', students: 850, status: 'active' },
];

export function ListWidget() {
  return (
    <div className="glass-card p-5 h-full">
      <div className="flex items-center justify-between mb-4">
        <h3 className="font-display text-lg font-semibold text-foreground">Recent Institutes</h3>
        <div className="p-2 rounded-lg bg-secondary/20">
          <Building2 size={18} className="text-secondary" />
        </div>
      </div>
      
      <div className="space-y-2">
        {institutes.map((institute, index) => (
          <motion.div
            key={institute.name}
            initial={{ opacity: 0, y: 10 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: index * 0.1 }}
            className="flex items-center justify-between p-3 rounded-lg bg-muted/50 hover:bg-muted transition-colors cursor-pointer group"
          >
            <div className="flex items-center gap-3">
              <div className={`w-2 h-2 rounded-full ${
                institute.status === 'active' ? 'bg-primary' : 'bg-secondary'
              }`} />
              <div>
                <p className="text-sm font-medium text-foreground">{institute.name}</p>
                <p className="text-xs text-muted-foreground">{institute.students} students</p>
              </div>
            </div>
            <ArrowRight size={16} className="text-muted-foreground group-hover:text-primary transition-colors" />
          </motion.div>
        ))}
      </div>
    </div>
  );
}
