import { motion } from 'framer-motion';
import { AlertTriangle, Bell, Info } from 'lucide-react';

const notifications = [
  { type: 'warning', message: 'New Curriculum Update - Grade 10', time: '5 min ago' },
  { type: 'info', message: '3 new institutes pending approval', time: '1 hour ago' },
  { type: 'alert', message: 'Payment gateway maintenance scheduled', time: '2 hours ago' },
];

const iconMap = {
  warning: AlertTriangle,
  info: Info,
  alert: Bell,
};

export function NotificationsWidget() {
  return (
    <div className="glass-card p-5 h-full neon-border-magenta">
      <div className="flex items-center justify-between mb-4">
        <h3 className="font-display text-lg font-semibold text-foreground">Notifications</h3>
        <span className="px-2 py-1 text-xs rounded-full bg-secondary text-secondary-foreground font-medium">
          {notifications.length} new
        </span>
      </div>
      
      <div className="space-y-3">
        {notifications.map((notification, index) => {
          const Icon = iconMap[notification.type as keyof typeof iconMap];
          
          return (
            <motion.div
              key={index}
              initial={{ opacity: 0, x: -20 }}
              animate={{ opacity: 1, x: 0 }}
              transition={{ delay: index * 0.1 }}
              className="flex items-start gap-3 p-3 rounded-lg bg-muted/50 hover:bg-muted transition-colors cursor-pointer"
            >
              <div className={`p-1.5 rounded-lg ${notification.type === 'warning' ? 'bg-secondary/20' : 'bg-primary/20'}`}>
                <Icon
                  size={14}
                  className={notification.type === 'warning' ? 'text-secondary' : 'text-primary'}
                />
              </div>
              <div className="flex-1 min-w-0">
                <p className="text-sm text-foreground truncate">{notification.message}</p>
                <p className="text-xs text-muted-foreground">{notification.time}</p>
              </div>
            </motion.div>
          );
        })}
      </div>
    </div>
  );
}
