import { motion } from 'framer-motion';
import { BarChart, Bar, XAxis, YAxis, Tooltip, ResponsiveContainer } from 'recharts';

const data = [
  { name: 'Jan', revenue: 4200 },
  { name: 'Feb', revenue: 5800 },
  { name: 'Mar', revenue: 4900 },
  { name: 'Apr', revenue: 6800 },
  { name: 'May', revenue: 7200 },
  { name: 'Jun', revenue: 8500 },
];

export function RevenueWidget() {
  return (
    <motion.div
      initial={{ opacity: 0 }}
      animate={{ opacity: 1 }}
      className="glass-card p-5 h-full neon-border-magenta"
    >
      <h3 className="font-display text-lg font-semibold text-foreground mb-4">Revenue Overview</h3>
      
      <div className="h-48">
        <ResponsiveContainer width="100%" height="100%">
          <BarChart data={data}>
            <defs>
              <linearGradient id="colorRevenue" x1="0" y1="0" x2="0" y2="1">
                <stop offset="5%" stopColor="hsl(320, 100%, 60%)" stopOpacity={0.8} />
                <stop offset="95%" stopColor="hsl(320, 100%, 60%)" stopOpacity={0.2} />
              </linearGradient>
            </defs>
            <XAxis
              dataKey="name"
              axisLine={false}
              tickLine={false}
              tick={{ fill: 'hsl(215, 20%, 65%)', fontSize: 12 }}
            />
            <YAxis
              axisLine={false}
              tickLine={false}
              tick={{ fill: 'hsl(215, 20%, 65%)', fontSize: 12 }}
            />
            <Tooltip
              contentStyle={{
                backgroundColor: 'hsl(222, 47%, 11%)',
                border: '1px solid hsl(320, 100%, 60%)',
                borderRadius: '8px',
                color: 'white',
              }}
              formatter={(value) => [`$${value}`, 'Revenue']}
            />
            <Bar
              dataKey="revenue"
              fill="url(#colorRevenue)"
              radius={[4, 4, 0, 0]}
            />
          </BarChart>
        </ResponsiveContainer>
      </div>
    </motion.div>
  );
}
