import { motion } from 'framer-motion';
import { Building2, Users, DollarSign, Activity } from 'lucide-react';

const stats = [
  { label: 'Total Institutes', value: '248', change: '+12%', icon: Building2, variant: 'primary' },
  { label: 'Active Users', value: '15,842', change: '+8.2%', icon: Users, variant: 'secondary' },
  { label: 'Monthly Revenue', value: '$52.4K', change: '+23%', icon: DollarSign, variant: 'primary' },
  { label: 'System Uptime', value: '99.9%', change: '', icon: Activity, variant: 'secondary' },
];

export function StatsWidget() {
  return (
    <div className="grid grid-cols-2 md:grid-cols-4 gap-4 h-full">
      {stats.map((stat, index) => {
        const Icon = stat.icon;
        const isPrimary = stat.variant === 'primary';
        
        return (
          <motion.div
            key={stat.label}
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: index * 0.1 }}
            className={`glass-card p-4 flex flex-col justify-between ${
              isPrimary ? 'neon-border-cyan' : 'neon-border-magenta'
            }`}
          >
            <div className="flex items-center justify-between mb-3">
              <div className={`p-2 rounded-lg ${isPrimary ? 'bg-primary/20' : 'bg-secondary/20'}`}>
                <Icon
                  size={20}
                  className={isPrimary ? 'text-primary' : 'text-secondary'}
                />
              </div>
              {stat.change && (
                <span className="text-xs font-medium text-primary bg-primary/10 px-2 py-0.5 rounded-full">
                  {stat.change}
                </span>
              )}
            </div>
            <div>
              <p className={`text-2xl font-bold font-display ${
                isPrimary ? 'text-primary' : 'text-secondary'
              }`}>
                {stat.value}
              </p>
              <p className="text-sm text-muted-foreground mt-1">{stat.label}</p>
            </div>
          </motion.div>
        );
      })}
    </div>
  );
}
