import { motion } from 'framer-motion';
import { MessageSquare, Clock, CheckCircle } from 'lucide-react';

const tickets = [
  { id: '#1234', subject: 'Payment issue', priority: 'high', time: '2h ago' },
  { id: '#1235', subject: 'Login problem', priority: 'medium', time: '4h ago' },
  { id: '#1236', subject: 'Feature request', priority: 'low', time: '1d ago' },
];

const priorityColors = {
  high: 'bg-destructive',
  medium: 'bg-neon-magenta',
  low: 'bg-neon-cyan',
};

export function TicketsWidget() {
  return (
    <div className="glass-card p-5 h-full">
      <div className="flex items-center justify-between mb-4">
        <h3 className="font-display text-lg font-semibold text-foreground">Support Tickets</h3>
        <span className="px-2 py-1 text-xs rounded-full bg-destructive/20 text-destructive">
          3 open
        </span>
      </div>
      
      <div className="space-y-2">
        {tickets.map((ticket, index) => (
          <motion.div
            key={ticket.id}
            initial={{ opacity: 0, y: 10 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: index * 0.1 }}
            className="flex items-center justify-between p-3 rounded-lg bg-muted/50 hover:bg-muted transition-colors cursor-pointer"
          >
            <div className="flex items-center gap-3">
              <div className={`w-2 h-2 rounded-full ${priorityColors[ticket.priority as keyof typeof priorityColors]}`} />
              <div>
                <div className="flex items-center gap-2">
                  <span className="text-xs text-muted-foreground">{ticket.id}</span>
                  <span className="text-sm font-medium text-foreground">{ticket.subject}</span>
                </div>
                <div className="flex items-center gap-1 text-xs text-muted-foreground">
                  <Clock size={10} />
                  {ticket.time}
                </div>
              </div>
            </div>
            <MessageSquare size={16} className="text-muted-foreground" />
          </motion.div>
        ))}
      </div>
    </div>
  );
}
