import { NavGroup } from '@/types/dashboard';

export const navigationData: NavGroup[] = [
  {
    id: 'dashboard',
    title: 'Dashboard',
    icon: 'LayoutDashboard',
    items: [
      { id: 'overview', title: 'Platform Overview', icon: 'Home', path: '/' },
    ],
  },
  {
    id: 'institute-management',
    title: 'Institute Management',
    icon: 'Building2',
    items: [
      { id: 'create-institute', title: 'Create Institute', icon: 'Plus', path: '/institutes/create' },
      { id: 'manage-institutes', title: 'Manage Institutes', icon: 'Building', path: '/institutes' },
      { id: 'assign-admin', title: 'Assign Admin', icon: 'UserCog', path: '/institutes/admin' },
      { id: 'suspend-institute', title: 'Suspend / Activate', icon: 'Power', path: '/institutes/status' },
    ],
  },
  {
    id: 'user-management',
    title: 'User Management',
    icon: 'Users',
    items: [
      { id: 'platform-users', title: 'Platform Users', icon: 'Users', path: '/users' },
      { id: 'support-staff', title: 'Support Staff', icon: 'Headphones', path: '/users/support' },
      { id: 'operations', title: 'Operations Team', icon: 'Briefcase', path: '/users/operations' },
    ],
  },
  {
    id: 'roles-permissions',
    title: 'Roles & Permissions',
    icon: 'Shield',
    items: [
      { id: 'role-management', title: 'Role Management', icon: 'UserCheck', path: '/roles' },
      { id: 'permission-management', title: 'Permission Management', icon: 'Key', path: '/permissions' },
      { id: 'assign-permissions', title: 'Assign Permissions', icon: 'ShieldCheck', path: '/permissions/assign' },
    ],
  },
  {
    id: 'reports',
    title: 'Platform Reports',
    icon: 'BarChart3',
    items: [
      { id: 'institute-reports', title: 'Institute Reports', icon: 'FileBarChart', path: '/reports/institutes' },
      { id: 'user-activity', title: 'User Activity', icon: 'Activity', path: '/reports/activity' },
      { id: 'system-usage', title: 'System Usage', icon: 'Cpu', path: '/reports/usage' },
      { id: 'financial-reports', title: 'Financial Reports', icon: 'DollarSign', path: '/reports/financial' },
    ],
  },
  {
    id: 'security',
    title: 'Security & Audit',
    icon: 'Lock',
    items: [
      { id: 'audit-logs', title: 'Audit Logs', icon: 'FileText', path: '/security/audit' },
      { id: 'login-logs', title: 'Login Logs', icon: 'LogIn', path: '/security/login' },
      { id: 'ip-whitelist', title: 'IP Whitelist', icon: 'Globe', path: '/security/whitelist' },
      { id: 'security-settings', title: 'Security Settings', icon: 'Settings', path: '/security/settings' },
    ],
  },
  {
    id: 'platform-settings',
    title: 'Platform Settings',
    icon: 'Settings',
    items: [
      { id: 'branding', title: 'Branding', icon: 'Palette', path: '/settings/branding' },
      { id: 'email-config', title: 'Email/SMS/WhatsApp', icon: 'Mail', path: '/settings/messaging' },
      { id: 'payment-gateways', title: 'Payment Gateways', icon: 'CreditCard', path: '/settings/payments' },
      { id: 'maintenance', title: 'Maintenance Mode', icon: 'Wrench', path: '/settings/maintenance' },
      { id: 'system-config', title: 'System Configuration', icon: 'Cog', path: '/settings/system' },
    ],
  },
  {
    id: 'subscriptions',
    title: 'Subscription & Billing',
    icon: 'Receipt',
    items: [
      { id: 'plans', title: 'Subscription Plans', icon: 'Package', path: '/billing/plans' },
      { id: 'coupons', title: 'Coupons / Discounts', icon: 'Ticket', path: '/billing/coupons' },
      { id: 'billing-history', title: 'Billing History', icon: 'History', path: '/billing/history' },
      { id: 'invoices', title: 'Invoices', icon: 'FileText', path: '/billing/invoices' },
      { id: 'payment-methods', title: 'Payment Methods', icon: 'Wallet', path: '/billing/methods' },
    ],
  },
  {
    id: 'support',
    title: 'Support System',
    icon: 'LifeBuoy',
    items: [
      { id: 'tickets', title: 'Support Tickets', icon: 'MessageSquare', path: '/support/tickets', badge: 12 },
      { id: 'categories', title: 'Ticket Categories', icon: 'Tag', path: '/support/categories' },
      { id: 'agents', title: 'Support Agents', icon: 'HeadphonesIcon', path: '/support/agents' },
    ],
  },
  {
    id: 'broadcast',
    title: 'Platform Broadcast',
    icon: 'Megaphone',
    items: [
      { id: 'announcements', title: 'Announcements', icon: 'Bell', path: '/broadcast/announcements' },
      { id: 'email-broadcast', title: 'Email Broadcast', icon: 'Send', path: '/broadcast/email' },
      { id: 'sms-broadcast', title: 'SMS Broadcast', icon: 'Smartphone', path: '/broadcast/sms' },
    ],
  },
];
