# MongoDB Quick Fix - Kali Linux GPG Issue

The MongoDB repository has a GPG key issue on newer Kali Linux systems. Here are **3 easy solutions**:

## ✅ Solution 1: Use MongoDB Atlas (Cloud - RECOMMENDED)

**This is the easiest and fastest solution:**

1. **Sign up for free MongoDB Atlas:**
   - Go to: https://www.mongodb.com/cloud/atlas/register
   - Create a free account (no credit card needed)

2. **Create a free cluster:**
   - Click "Build a Database"
   - Choose FREE (M0) tier
   - Select a region close to you
   - Click "Create"

3. **Set up database user:**
   - Go to "Database Access" → "Add New Database User"
   - Username: `balaji-admin`
   - Password: Create a strong password (save it!)
   - Privileges: "Atlas admin"
   - Click "Add User"

4. **Set up network access:**
   - Go to "Network Access" → "Add IP Address"
   - Click "Allow Access from Anywhere" (for development)
   - Click "Confirm"

5. **Get connection string:**
   - Go to "Database" → "Connect"
   - Click "Connect your application"
   - Copy the connection string
   - It looks like: `mongodb+srv://balaji-admin:<password>@cluster0.xxxxx.mongodb.net/?retryWrites=true&w=majority`

6. **Update server/.env:**
   ```bash
   cd server
   nano .env
   ```
   
   Update the MONGODB_URI line:
   ```env
   MONGODB_URI=mongodb+srv://balaji-admin:YOUR_PASSWORD@cluster0.xxxxx.mongodb.net/balaji-tour-travel?retryWrites=true&w=majority
   ```
   
   Replace:
   - `YOUR_PASSWORD` with your actual password
   - `cluster0.xxxxx` with your cluster name
   - Add `/balaji-tour-travel` before the `?` for database name

7. **Done!** Now start your server:
   ```bash
   npm run dev
   ```

---

## ✅ Solution 2: Use Docker (Quick & Easy)

**If you have Docker installed:**

```bash
# Pull MongoDB image
docker pull mongo:7.0

# Run MongoDB container
docker run -d \
  --name mongodb \
  -p 27017:27017 \
  -e MONGO_INITDB_DATABASE=balaji-tour-travel \
  -v mongodb_data:/data/db \
  mongo:7.0

# Verify it's running
docker ps

# Check logs
docker logs mongodb
```

**To stop MongoDB:**
```bash
docker stop mongodb
```

**To start MongoDB again:**
```bash
docker start mongodb
```

**Your server/.env should have:**
```env
MONGODB_URI=mongodb://localhost:27017/balaji-tour-travel
```

---

## ✅ Solution 3: Fix GPG Key Issue (Advanced)

If you want to install MongoDB locally, try this workaround:

```bash
# Remove the problematic repository
sudo rm /etc/apt/sources.list.d/mongodb-org-7.0.list
sudo rm /usr/share/keyrings/mongodb-server-7.0.gpg

# Add MongoDB repository with workaround
echo "deb [ arch=amd64,arm64 ] https://repo.mongodb.org/apt/ubuntu jammy/mongodb-org/7.0 multiverse" | sudo tee /etc/apt/sources.list.d/mongodb-org-7.0.list

# Update with allow-insecure
sudo apt update --allow-insecure-repositories

# Install MongoDB (may show warnings, but should work)
sudo apt install -y mongodb-org --allow-unauthenticated

# Start MongoDB
sudo systemctl start mongod
sudo systemctl enable mongod
```

**⚠️ Warning:** This bypasses security checks. Use Solution 1 or 2 for better security.

---

## 🚀 After MongoDB is Running

1. **Seed the database:**
   ```bash
   cd server
   npm run seed
   ```

2. **Start the server:**
   ```bash
   npm run dev
   ```

3. **You should see:**
   ```
   ✅ MongoDB Connected: ...
   📦 Database: balaji-tour-travel
   🚀 Server running on port 5000
   ```

---

## 💡 Recommendation

**Use Solution 1 (MongoDB Atlas)** - It's:
- ✅ Free forever (512MB storage)
- ✅ No installation needed
- ✅ Works from anywhere
- ✅ Automatic backups
- ✅ No local resource usage

