# MongoDB Setup Guide

## Option 1: Install MongoDB Locally (Recommended for Development)

### For Ubuntu/Debian/Kali Linux:

```bash
# Import MongoDB public GPG key
curl -fsSL https://www.mongodb.org/static/pgp/server-7.0.asc | sudo gpg -o /usr/share/keyrings/mongodb-server-7.0.gpg --dearmor

# Add MongoDB repository
echo "deb [ arch=amd64,arm64 signed-by=/usr/share/keyrings/mongodb-server-7.0.gpg ] https://repo.mongodb.org/apt/ubuntu jammy/mongodb-org/7.0 multiverse" | sudo tee /etc/apt/sources.list.d/mongodb-org-7.0.list

# Update package list
sudo apt update

# Install MongoDB
sudo apt install -y mongodb-org

# Start MongoDB service
sudo systemctl start mongod
sudo systemctl enable mongod

# Check status
sudo systemctl status mongod
```

### Verify Installation:

```bash
# Check MongoDB version
mongod --version

# Check if MongoDB is running
sudo systemctl status mongod

# Test connection
mongosh
# Or older versions: mongo
```

### Start MongoDB (if not running):

```bash
sudo systemctl start mongod
```

---

## Option 2: Use MongoDB Atlas (Cloud - Free Tier)

### Steps:

1. **Sign up for MongoDB Atlas:**
   - Go to https://www.mongodb.com/cloud/atlas/register
   - Create a free account

2. **Create a Cluster:**
   - Choose FREE tier (M0)
   - Select a cloud provider and region
   - Create cluster (takes 3-5 minutes)

3. **Set up Database Access:**
   - Go to "Database Access"
   - Add new database user
   - Username: `balaji-admin`
   - Password: Create a strong password
   - Database User Privileges: "Atlas admin"

4. **Set up Network Access:**
   - Go to "Network Access"
   - Click "Add IP Address"
   - Click "Allow Access from Anywhere" (for development)
   - Or add your specific IP

5. **Get Connection String:**
   - Go to "Database" → "Connect"
   - Click "Connect your application"
   - Copy the connection string
   - It looks like: `mongodb+srv://username:password@cluster0.xxxxx.mongodb.net/?retryWrites=true&w=majority`

6. **Update server/.env:**
   ```env
   MONGODB_URI=mongodb+srv://balaji-admin:YOUR_PASSWORD@cluster0.xxxxx.mongodb.net/balaji-tour-travel?retryWrites=true&w=majority
   ```
   Replace:
   - `YOUR_PASSWORD` with your database user password
   - `cluster0.xxxxx` with your actual cluster name
   - Add database name: `/balaji-tour-travel`

---

## Option 3: Use Docker (Quick Setup)

```bash
# Pull MongoDB image
docker pull mongo:latest

# Run MongoDB container
docker run -d \
  --name mongodb \
  -p 27017:27017 \
  -e MONGO_INITDB_DATABASE=balaji-tour-travel \
  mongo:latest

# Check if running
docker ps

# Stop MongoDB
docker stop mongodb

# Start MongoDB
docker start mongodb
```

---

## Verify Connection

After setting up MongoDB, test the connection:

```bash
cd server
node -e "
import('dotenv').then(dotenv => {
  dotenv.default.config();
  import('mongoose').then(mongoose => {
    mongoose.default.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/balaji-tour-travel')
      .then(() => {
        console.log('✅ MongoDB connection successful!');
        process.exit(0);
      })
      .catch(err => {
        console.error('❌ MongoDB connection failed:', err.message);
        process.exit(1);
      });
  });
});
"
```

---

## Common Issues

### Issue 1: "Connection refused"
**Solution:** MongoDB is not running
```bash
sudo systemctl start mongod
```

### Issue 2: "Authentication failed"
**Solution:** Check username/password in connection string

### Issue 3: "Network timeout"
**Solution:** 
- For local: Check if MongoDB is running
- For Atlas: Check Network Access settings (whitelist your IP)

### Issue 4: "Operation buffering timed out"
**Solution:** MongoDB is not accessible. Check:
1. Is MongoDB running? (`sudo systemctl status mongod`)
2. Is connection string correct in `server/.env`?
3. For Atlas: Is your IP whitelisted?

---

## Quick Start (After MongoDB is Running)

```bash
# 1. Make sure MongoDB is running
sudo systemctl status mongod

# 2. Seed the database
cd server
npm run seed

# 3. Start the server
npm run dev
```

You should see:
```
✅ MongoDB Connected: localhost:27017
📦 Database: balaji-tour-travel
🚀 Server running on port 5000
```

