# 🔧 Quick Fix: Port 5000 Already in Use

## Problem:
Port 5000 is already in use by another process (PID: 25807)

## Solution:

### Option 1: Kill the Process (Recommended)

Run this command in your terminal:
```bash
sudo kill -9 25807
```

Or use the helper script:
```bash
./kill-port.sh
```

### Option 2: Find and Kill All Node Processes

```bash
# Find all node processes
ps aux | grep node | grep -v grep

# Kill all node processes (be careful!)
pkill -f "node.*server"
pkill -f nodemon
```

### Option 3: Use a Different Port

If you can't kill the process, use a different port:

1. Update `server/.env`:
   ```env
   PORT=5001
   ```

2. Update `client/.env`:
   ```env
   VITE_API_URL=http://localhost:5001/api
   ```

3. Restart both server and client

## After Killing the Process:

1. **Start the server:**
   ```bash
   cd server
   npm run dev
   ```

2. **You should see:**
   ```
   ✅ MongoDB Connected: ...
   📦 Database: balaji-tour-travel
   🚀 Server running on port 5000
   ✅ Admin user created: admin@balajitour.com
   ```

3. **Then login to admin panel:**
   - Go to: http://localhost:5173/admin/login
   - Email: `admin@balajitour.com`
   - Password: `admin123`

---

**Run `sudo kill -9 25807` to free port 5000, then restart your server!** 🚀

