# Balaji Tour & Travel - MERN Stack Application

A premium, production-ready Tour & Travel booking website built with the MERN stack (MongoDB, Express.js, React.js, Node.js).

## 🚀 Features

- **4 Main Pages**: Home, Packages, Package Details, Contact
- **10 Tour Packages** with detailed information
- **Full Booking System** with payment integration
- **Veegah Payment Gateway** integration
- **Admin Panel** for package and booking management
- **Need Help** floating support button
- **Premium UI/UX** with animations and modern design
- **Fully Responsive** for mobile, tablet, and desktop

## 📋 Prerequisites

- Node.js (v16 or higher)
- MongoDB (local or MongoDB Atlas)
- npm or yarn

## 🛠️ Installation

1. **Clone the repository**
   ```bash
   cd "Tour & Travel website"
   ```

2. **Install root dependencies**
   ```bash
   npm install
   ```

3. **Install server dependencies**
   ```bash
   cd server
   npm install
   ```

4. **Install client dependencies**
   ```bash
   cd ../client
   npm install
   ```

5. **Set up environment variables**

   Create `server/.env` file:
   ```env
   PORT=5000
   NODE_ENV=development
   MONGODB_URI=mongodb://localhost:27017/balaji-tour-travel
   JWT_SECRET=your-super-secret-jwt-key-change-in-production
   ADMIN_EMAIL=admin@balajitour.com
   ADMIN_PASSWORD=admin123
   VEEGAH_MERCHANT_ID=your_merchant_id
   VEEGAH_API_KEY=your_api_key
   VEEGAH_SECRET_KEY=your_secret_key
   VEEGAH_PAYMENT_URL=https://api.veegah.com/payment
   VEEGAH_CALLBACK_URL=http://localhost:5000/api/payments/callback
   CLIENT_URL=http://localhost:5173
   ```

   Create `client/.env` file:
   ```env
   VITE_API_URL=http://localhost:5000/api
   ```

6. **Seed the database**
   ```bash
   cd server
   npm run seed
   ```

## 🚀 Running the Application

### Development Mode

From the root directory, run:
```bash
npm run dev
```

This will start both the server (port 5000) and client (port 5173) concurrently.

### Or run separately:

**Start the server:**
```bash
cd server
npm run dev
```

**Start the client:**
```bash
cd client
npm run dev
```

## 📁 Project Structure

```
balaji-tour-travel/
├── client/                 # React frontend
│   ├── src/
│   │   ├── components/     # Reusable components
│   │   ├── pages/         # Page components
│   │   ├── services/      # API services
│   │   └── App.jsx        # Main app component
│   └── package.json
├── server/                 # Express backend
│   ├── config/           # Database configuration
│   ├── controllers/       # Route controllers
│   ├── models/           # MongoDB models
│   ├── routes/           # API routes
│   ├── middleware/       # Auth middleware
│   ├── scripts/          # Seed scripts
│   └── server.js         # Server entry point
└── package.json          # Root package.json
```

## 🔐 Admin Access

- **URL**: `http://localhost:5173/admin/login`
- **Email**: `admin@balajitour.com`
- **Password**: `admin123`

## 📱 Pages

1. **Home** (`/`) - Hero section, featured packages, testimonials
2. **Packages** (`/packages`) - All tour packages with filters
3. **Package Details** (`/package/:slug`) - Package details and booking form
4. **Contact** (`/contact`) - Contact form, map, FAQ
5. **Admin Dashboard** (`/admin/dashboard`) - Package and booking management

## 💳 Payment Integration

The application integrates with Veegah Payment Gateway. Update the Veegah credentials in `server/.env` for production use.

## 🎨 Technologies Used

### Frontend
- React.js
- Vite
- Tailwind CSS
- Framer Motion
- React Router DOM
- React Hook Form
- Swiper
- Lucide React Icons

### Backend
- Node.js
- Express.js
- MongoDB
- Mongoose
- JWT Authentication
- bcryptjs

## 📝 API Endpoints

### Packages
- `GET /api/packages` - Get all packages
- `GET /api/packages/featured` - Get featured packages
- `GET /api/packages/:id` - Get package by ID
- `GET /api/packages/slug/:slug` - Get package by slug
- `POST /api/packages` - Create package (Admin)
- `PUT /api/packages/:id` - Update package (Admin)
- `DELETE /api/packages/:id` - Delete package (Admin)

### Bookings
- `POST /api/bookings` - Create booking
- `GET /api/bookings` - Get all bookings (Admin)
- `GET /api/bookings/:id` - Get booking by ID

### Payments
- `POST /api/payments/create` - Create payment
- `POST /api/payments/callback` - Payment callback
- `GET /api/payments/verify/:bookingId` - Verify payment

### Auth
- `POST /api/auth/login` - Admin login
- `GET /api/auth/me` - Get current user (Admin)

## 🚢 Deployment

### Backend Deployment
1. Set environment variables on your hosting platform
2. Update `CLIENT_URL` to your frontend URL
3. Deploy to platforms like Heroku, Railway, or DigitalOcean

### Frontend Deployment
1. Build the production bundle:
   ```bash
   cd client
   npm run build
   ```
2. Deploy the `dist` folder to platforms like Vercel, Netlify, or AWS S3

## 📞 Support

- **Phone**: +91 9729849875
- **Email**: balajitourandtravels2026@gmail.com

## 📄 License

This project is proprietary and confidential.

---

Built with ❤️ for Balaji Tour & Travel

