# Quick Setup Guide

## Step 1: Install Dependencies

```bash
# Install root dependencies
npm install

# Install server dependencies
cd server && npm install && cd ..

# Install client dependencies
cd client && npm install && cd ..
```

## Step 2: Configure Environment

### Server Configuration

Create `server/.env` file:

```env
PORT=5000
NODE_ENV=development
MONGODB_URI=mongodb://localhost:27017/balaji-tour-travel
JWT_SECRET=your-super-secret-jwt-key-min-32-chars-long
ADMIN_EMAIL=admin@balajitour.com
ADMIN_PASSWORD=admin123
VEEGAH_MERCHANT_ID=your_merchant_id
VEEGAH_API_KEY=your_api_key
VEEGAH_SECRET_KEY=your_secret_key
VEEGAH_PAYMENT_URL=https://api.veegah.com/payment
VEEGAH_CALLBACK_URL=http://localhost:5000/api/payments/callback
CLIENT_URL=http://localhost:5173
```

### Client Configuration

Create `client/.env` file:

```env
VITE_API_URL=http://localhost:5000/api
```

## Step 3: Start MongoDB

Make sure MongoDB is running on your system:

```bash
# If using local MongoDB
mongod

# Or use MongoDB Atlas connection string in MONGODB_URI
```

## Step 4: Seed Database

```bash
cd server
npm run seed
```

This will create 10 tour packages in your database.

## Step 5: Run the Application

### Option 1: Run Both Together (Recommended)

From root directory:
```bash
npm run dev
```

### Option 2: Run Separately

**Terminal 1 - Server:**
```bash
cd server
npm run dev
```

**Terminal 2 - Client:**
```bash
cd client
npm run dev
```

## Step 6: Access the Application

- **Frontend**: http://localhost:5173
- **Backend API**: http://localhost:5000
- **Admin Panel**: http://localhost:5173/admin/login
  - Email: `admin@balajitour.com`
  - Password: `admin123`

## Troubleshooting

### MongoDB Connection Error
- Make sure MongoDB is running
- Check `MONGODB_URI` in `server/.env`
- For MongoDB Atlas, ensure your IP is whitelisted

### Port Already in Use
- Change `PORT` in `server/.env` for backend
- Change port in `client/vite.config.js` for frontend

### Module Not Found
- Delete `node_modules` and reinstall:
  ```bash
  rm -rf node_modules client/node_modules server/node_modules
  npm install
  cd server && npm install && cd ..
  cd client && npm install && cd ..
  ```

## Production Build

### Build Frontend
```bash
cd client
npm run build
```

The `dist` folder contains the production build.

### Start Production Server
```bash
cd server
NODE_ENV=production npm start
```

---

Happy Coding! 🚀

