# 🚀 START HERE - Complete Setup Guide

## ✅ All Issues Fixed!

The following have been automatically fixed:
- ✅ Environment files created (`server/.env` and `client/.env`)
- ✅ Dependencies installed
- ✅ Code issues resolved
- ✅ Port 5000 is free

## 📋 Remaining Step: MongoDB Setup

**You need to set up MongoDB before starting the server.**

### Option 1: MongoDB Atlas (Cloud - ⭐ RECOMMENDED - 5 minutes)

1. **Sign up:** https://www.mongodb.com/cloud/atlas/register
2. **Create Free Cluster:**
   - Click "Build a Database"
   - Choose FREE (M0) tier
   - Select region → Create
3. **Database Access:**
   - Go to "Database Access" → "Add New Database User"
   - Username: `balaji-admin`
   - Password: Create strong password (save it!)
   - Click "Add User"
4. **Network Access:**
   - Go to "Network Access" → "Add IP Address"
   - Click "Allow Access from Anywhere" (for development)
   - Click "Confirm"
5. **Get Connection String:**
   - Go to "Database" → "Connect" → "Connect your application"
   - Copy the connection string
6. **Update `server/.env`:**
   ```bash
   nano server/.env
   ```
   Update this line:
   ```env
   MONGODB_URI=mongodb+srv://balaji-admin:YOUR_PASSWORD@cluster0.xxxxx.mongodb.net/balaji-tour-travel?retryWrites=true&w=majority
   ```
   Replace `YOUR_PASSWORD` and `cluster0.xxxxx` with your actual values.

### Option 2: Local MongoDB Installation

See `MONGODB_SETUP.md` for detailed instructions.

---

## 🎯 Quick Start (After MongoDB is Ready)

### Step 1: Seed the Database
```bash
cd server
npm run seed
```
You should see: `✅ 10 Tour packages seeded successfully!`

### Step 2: Start the Server
```bash
cd server
npm run dev
```
You should see:
```
✅ MongoDB Connected: ...
📦 Database: balaji-tour-travel
🚀 Server running on port 5000
✅ Admin user created: admin@balajitour.com
```

### Step 3: Start the Client (New Terminal)
```bash
cd client
npm run dev
```
You should see:
```
  VITE v4.x.x  ready in xxx ms

  ➜  Local:   http://localhost:5173/
```

### Step 4: Open Browser
- **Frontend:** http://localhost:5173
- **Admin Panel:** http://localhost:5173/admin/login
  - Email: `admin@balajitour.com`
  - Password: `admin123`

---

## 🧪 Test the Application

1. **Home Page:** Should show featured packages
2. **Packages Page:** Should show all 10 tour packages
3. **Package Details:** Click any package to see details
4. **Admin Login:** Login and manage packages/bookings

---

## 🐛 Troubleshooting

### "MongoDB connection timeout"
- Check if MongoDB is running (Atlas or local)
- Verify `MONGODB_URI` in `server/.env` is correct
- For Atlas: Check Network Access settings

### "Failed to load packages"
- Make sure server is running (`npm run dev` in server directory)
- Check if database is seeded (`npm run seed`)
- Check browser console for errors

### "Port 5000 already in use"
```bash
# Kill the process
sudo lsof -ti :5000 | xargs sudo kill -9
# Or use: ./kill-port.sh
```

### "Cannot connect to server"
- Make sure server is running on port 5000
- Check `VITE_API_URL` in `client/.env` is `http://localhost:5000/api`

---

## 📚 Documentation Files

- `MONGODB_SETUP.md` - MongoDB installation guide
- `MONGODB_QUICK_FIX.md` - Quick MongoDB fixes
- `TROUBLESHOOTING.md` - Detailed troubleshooting
- `README.md` - Complete project documentation
- `SETUP.md` - Original setup guide

---

## ✅ Checklist

- [ ] MongoDB Atlas account created OR MongoDB installed locally
- [ ] `MONGODB_URI` updated in `server/.env`
- [ ] Database seeded (`npm run seed`)
- [ ] Server running (`npm run dev` in server directory)
- [ ] Client running (`npm run dev` in client directory)
- [ ] Browser opened to http://localhost:5173

---

## 🎉 You're All Set!

Once MongoDB is configured and both server and client are running, your Tour & Travel website will be fully functional!

**Need Help?** Check `TROUBLESHOOTING.md` or the documentation files listed above.

