# 🔐 Update MongoDB Password

Your MongoDB connection string has been added to `server/.env`, but you need to replace `<db_password>` with your actual password.

## Steps:

1. **Open the .env file:**
   ```bash
   cd server
   nano .env
   # or use your preferred editor
   ```

2. **Find this line:**
   ```env
   MONGODB_URI=mongodb+srv://akshayjalandhra15_db_user:<db_password>@cluster0.ljfrvce.mongodb.net/balaji-tour-travel?retryWrites=true&w=majority
   ```

3. **Replace `<db_password>` with your actual MongoDB password:**
   ```env
   MONGODB_URI=mongodb+srv://akshayjalandhra15_db_user:YOUR_ACTUAL_PASSWORD@cluster0.ljfrvce.mongodb.net/balaji-tour-travel?retryWrites=true&w=majority
   ```

4. **Save the file** (Ctrl+X, then Y, then Enter if using nano)

5. **Test the connection:**
   ```bash
   cd server
   npm run dev
   ```

   You should see:
   ```
   ✅ MongoDB Connected: cluster0-shard-00-00.ljfrvce.mongodb.net
   📦 Database: balaji-tour-travel
   🚀 Server running on port 5000
   ```

## ⚠️ Important Notes:

- **Don't commit your password to Git** - The `.env` file should be in `.gitignore` (it already is)
- **Keep your password secure** - Never share it publicly
- **If you forgot your password:**
  - Go to MongoDB Atlas → Database Access
  - Edit your user → Reset Password

## Quick Test:

After updating the password, test the connection:

```bash
cd server
node -e "
import('dotenv').then(dotenv => {
  dotenv.default.config();
  import('mongoose').then(mongoose => {
    mongoose.default.connect(process.env.MONGODB_URI)
      .then(() => {
        console.log('✅ MongoDB connection successful!');
        process.exit(0);
      })
      .catch(err => {
        console.error('❌ MongoDB connection failed:', err.message);
        process.exit(1);
      });
  });
});
"
```

---

**After updating the password, you can:**
1. Seed the database: `npm run seed`
2. Start the server: `npm run dev`
3. Start the client: `cd ../client && npm run dev`

