import { motion } from 'framer-motion';
import { Shield, Lock, Eye, FileText, UserCheck, Database } from 'lucide-react';

const PrivacyPolicy = () => {
  const sections = [
    {
      icon: FileText,
      title: 'Information We Collect',
      content: [
        'Personal Information: When you book a tour or contact us, we may collect personal information such as your name, email address, phone number, date of birth, passport details, and payment information.',
        'Travel Preferences: We collect information about your travel preferences, dietary requirements, and special requests to provide you with the best possible service.',
        'Usage Data: We automatically collect information about how you interact with our website, including your IP address, browser type, pages visited, and time spent on our site.',
        'Cookies: We use cookies and similar tracking technologies to enhance your browsing experience and analyze website traffic.',
      ],
    },
    {
      icon: Database,
      title: 'How We Use Your Information',
      content: [
        'Service Delivery: We use your information to process bookings, manage reservations, and provide customer support.',
        'Communication: We may contact you regarding your bookings, send confirmations, updates, and respond to your inquiries.',
        'Marketing: With your consent, we may send you promotional materials about our services, special offers, and travel packages.',
        'Improvement: We analyze usage data to improve our website, services, and customer experience.',
        'Legal Compliance: We may use your information to comply with legal obligations, resolve disputes, and enforce our agreements.',
      ],
    },
    {
      icon: Lock,
      title: 'Data Security',
      content: [
        'We implement industry-standard security measures to protect your personal information from unauthorized access, alteration, disclosure, or destruction.',
        'All sensitive data, including payment information, is encrypted using secure socket layer (SSL) technology.',
        'We regularly review and update our security practices to ensure the highest level of protection.',
        'However, no method of transmission over the internet or electronic storage is 100% secure, and we cannot guarantee absolute security.',
      ],
    },
    {
      icon: Eye,
      title: 'Information Sharing',
      content: [
        'Service Providers: We may share your information with trusted third-party service providers who assist us in operating our website, processing payments, and delivering services.',
        'Travel Partners: We may share necessary information with hotels, airlines, tour operators, and other travel service providers to fulfill your bookings.',
        'Legal Requirements: We may disclose your information if required by law, court order, or government regulation.',
        'Business Transfers: In the event of a merger, acquisition, or sale of assets, your information may be transferred to the acquiring entity.',
        'We do not sell, rent, or trade your personal information to third parties for their marketing purposes.',
      ],
    },
    {
      icon: UserCheck,
      title: 'Your Rights',
      content: [
        'Access: You have the right to access and receive a copy of your personal information.',
        'Correction: You can request corrections to any inaccurate or incomplete information.',
        'Deletion: You may request deletion of your personal information, subject to legal and contractual obligations.',
        'Objection: You can object to the processing of your personal information for certain purposes.',
        'Data Portability: You have the right to receive your data in a structured, commonly used format.',
        'Withdrawal of Consent: You can withdraw your consent for data processing at any time.',
      ],
    },
    {
      icon: Shield,
      title: 'Cookies and Tracking',
      content: [
        'We use cookies to enhance your browsing experience, analyze website traffic, and personalize content.',
        'You can control cookies through your browser settings. However, disabling cookies may affect website functionality.',
        'We use both session cookies (temporary) and persistent cookies (stored on your device).',
        'Third-party services, such as Google Analytics, may also use cookies to collect information about your website usage.',
      ],
    },
  ];

  return (
    <div className="pt-20">
      {/* Hero Section */}
      <section className="relative h-[50vh] flex items-center justify-center overflow-hidden bg-gradient-to-r from-primary-600 to-primary-800">
        <div className="absolute inset-0 opacity-20">
          <img
            src="https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?w=1920"
            alt="Privacy Policy"
            className="w-full h-full object-cover"
          />
        </div>
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          className="relative z-10 text-center text-white px-4"
        >
          <Shield className="w-16 h-16 mx-auto mb-4" />
          <h1 className="text-5xl md:text-6xl font-bold mb-4">Privacy Policy</h1>
          <p className="text-xl md:text-2xl text-gray-200 max-w-3xl mx-auto">
            Your privacy is important to us. Learn how we collect, use, and protect your information.
          </p>
          <p className="text-sm text-gray-300 mt-4">
            Last updated: {new Date().toLocaleDateString('en-US', { year: 'numeric', month: 'long', day: 'numeric' })}
          </p>
        </motion.div>
      </section>

      {/* Introduction */}
      <section className="py-16 bg-white">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="prose prose-lg max-w-none"
          >
            <p className="text-gray-700 text-lg leading-relaxed mb-6">
              At <strong>Balaji Tour & Travel</strong>, we are committed to protecting your privacy and ensuring the security of your personal information. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you visit our website, use our services, or interact with us.
            </p>
            <p className="text-gray-700 text-lg leading-relaxed">
              By using our services, you agree to the collection and use of information in accordance with this policy. If you do not agree with our policies and practices, please do not use our services.
            </p>
          </motion.div>
        </div>
      </section>

      {/* Main Content Sections */}
      <section className="py-16 bg-gray-50">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-12">
            {sections.map((section, index) => {
              const Icon = section.icon;
              return (
                <motion.div
                  key={index}
                  initial={{ opacity: 0, y: 20 }}
                  whileInView={{ opacity: 1, y: 0 }}
                  viewport={{ once: true }}
                  transition={{ delay: index * 0.1 }}
                  className="bg-white p-8 rounded-2xl shadow-lg border border-gray-100"
                >
                  <div className="flex items-center mb-6">
                    <div className="w-12 h-12 bg-primary-100 rounded-xl flex items-center justify-center mr-4">
                      <Icon className="w-6 h-6 text-primary-600" />
                    </div>
                    <h2 className="text-3xl font-bold text-gray-900">{section.title}</h2>
                  </div>
                  <ul className="space-y-4">
                    {section.content.map((item, itemIndex) => (
                      <li key={itemIndex} className="flex items-start">
                        <span className="text-primary-600 mr-3 mt-1">•</span>
                        <span className="text-gray-700 leading-relaxed">{item}</span>
                      </li>
                    ))}
                  </ul>
                </motion.div>
              );
            })}
          </div>
        </div>
      </section>

      {/* Additional Information */}
      <section className="py-16 bg-white">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="space-y-8"
          >
            <div className="bg-primary-50 p-8 rounded-2xl border border-primary-100">
              <h2 className="text-2xl font-bold text-gray-900 mb-4">Data Retention</h2>
              <p className="text-gray-700 leading-relaxed">
                We retain your personal information for as long as necessary to fulfill the purposes outlined in this Privacy Policy, unless a longer retention period is required or permitted by law. When we no longer need your information, we will securely delete or anonymize it.
              </p>
            </div>

            <div className="bg-gray-50 p-8 rounded-2xl border border-gray-200">
              <h2 className="text-2xl font-bold text-gray-900 mb-4">Children's Privacy</h2>
              <p className="text-gray-700 leading-relaxed">
                Our services are not intended for individuals under the age of 18. We do not knowingly collect personal information from children. If you believe we have collected information from a child, please contact us immediately, and we will take steps to delete such information.
              </p>
            </div>

            <div className="bg-primary-50 p-8 rounded-2xl border border-primary-100">
              <h2 className="text-2xl font-bold text-gray-900 mb-4">International Data Transfers</h2>
              <p className="text-gray-700 leading-relaxed">
                Your information may be transferred to and processed in countries other than your country of residence. These countries may have data protection laws that differ from those in your country. We take appropriate measures to ensure your information is protected in accordance with this Privacy Policy.
              </p>
            </div>

            <div className="bg-gray-50 p-8 rounded-2xl border border-gray-200">
              <h2 className="text-2xl font-bold text-gray-900 mb-4">Changes to This Privacy Policy</h2>
              <p className="text-gray-700 leading-relaxed">
                We may update this Privacy Policy from time to time to reflect changes in our practices or for other operational, legal, or regulatory reasons. We will notify you of any material changes by posting the new Privacy Policy on this page and updating the "Last updated" date. We encourage you to review this Privacy Policy periodically.
              </p>
            </div>

            <div className="bg-primary-50 p-8 rounded-2xl border border-primary-100">
              <h2 className="text-2xl font-bold text-gray-900 mb-4">Contact Us</h2>
              <p className="text-gray-700 leading-relaxed mb-4">
                If you have any questions, concerns, or requests regarding this Privacy Policy or our data practices, please contact us:
              </p>
              <div className="space-y-2 text-gray-700">
                <p><strong>Email:</strong> balajitourandtravels2026@gmail.com</p>
                <p><strong>Phone:</strong> +91 9729849875</p>
                <p><strong>Address:</strong> Building No. 1, Maham Main Road, Near Rathi Auto Electric, Maham, Rohtak, Haryana - 124112, India</p>
              </div>
            </div>
          </motion.div>
        </div>
      </section>
    </div>
  );
};

export default PrivacyPolicy;

