import { motion } from 'framer-motion';
import { FileText, Scale, AlertCircle, CheckCircle, XCircle, Info } from 'lucide-react';

const TermsAndConditions = () => {
  const sections = [
    {
      icon: FileText,
      title: 'Acceptance of Terms',
      content: [
        'By accessing and using the services of Balaji Tour & Travel, you acknowledge that you have read, understood, and agree to be bound by these Terms and Conditions.',
        'If you do not agree with any part of these terms, you must not use our services.',
        'We reserve the right to modify these terms at any time. Continued use of our services after changes constitutes acceptance of the modified terms.',
        'These terms apply to all users of our website and services, including browsers, customers, and contributors.',
      ],
    },
    {
      icon: CheckCircle,
      title: 'Booking and Reservations',
      content: [
        'All bookings are subject to availability and confirmation by Balaji Tour & Travel.',
        'A booking is considered confirmed only after receipt of full payment or the required deposit, as specified at the time of booking.',
        'You must provide accurate and complete information at the time of booking, including passport details, travel dates, and special requirements.',
        'We reserve the right to refuse any booking at our discretion.',
        'Booking confirmations will be sent via email. It is your responsibility to verify all details are correct.',
      ],
    },
    {
      icon: AlertCircle,
      title: 'Payment Terms',
      content: [
        'Payment terms vary by package and will be clearly communicated at the time of booking.',
        'A deposit is typically required to secure your booking, with the balance due before the travel date as specified.',
        'We accept various payment methods including credit cards, debit cards, bank transfers, and other methods as specified.',
        'All prices are in Indian Rupees (INR) unless otherwise stated and are subject to change without notice until booking is confirmed.',
        'Additional charges may apply for special requests, upgrades, or modifications to your booking.',
        'Refunds, if applicable, will be processed according to our cancellation policy.',
      ],
    },
    {
      icon: XCircle,
      title: 'Cancellation and Refund Policy',
      content: [
        'Cancellation requests must be made in writing via email or through our official channels.',
        'Cancellation charges apply as follows:',
        '  • Cancellation 30+ days before departure: 10% of total amount',
        '  • Cancellation 15-30 days before departure: 25% of total amount',
        '  • Cancellation 7-14 days before departure: 50% of total amount',
        '  • Cancellation less than 7 days before departure: No refund',
        'Refunds, if applicable, will be processed within 14-21 business days to the original payment method.',
        'Some services may have non-refundable components. This will be clearly stated at the time of booking.',
        'Force majeure events (natural disasters, pandemics, government restrictions) may affect cancellation terms.',
      ],
    },
    {
      icon: Scale,
      title: 'Travel Documents and Requirements',
      content: [
        'It is your responsibility to ensure you have valid travel documents, including passports, visas, and health certificates.',
        'Passport validity requirements vary by destination. Generally, passports should be valid for at least 6 months from the date of travel.',
        'We are not responsible for visa rejections or travel document issues. Visa fees and processing are your responsibility unless included in the package.',
        'You must comply with all health and vaccination requirements of your destination country.',
        'We recommend purchasing comprehensive travel insurance to cover unforeseen circumstances.',
      ],
    },
    {
      icon: Info,
      title: 'Travel Insurance',
      content: [
        'Travel insurance is highly recommended for all trips and may be mandatory for certain destinations.',
        'We can assist you in obtaining travel insurance, but the policy terms and coverage are between you and the insurance provider.',
        'Travel insurance should cover medical emergencies, trip cancellations, lost baggage, and other travel-related risks.',
        'We are not responsible for any claims or disputes with insurance providers.',
      ],
    },
  ];

  const additionalSections = [
    {
      title: 'Limitation of Liability',
      content: [
        'Balaji Tour & Travel acts as an intermediary between you and various service providers (hotels, airlines, tour operators, etc.).',
        'We are not liable for any loss, damage, injury, or inconvenience caused by the acts or omissions of third-party service providers.',
        'Our liability is limited to the amount paid by you for the specific service in question.',
        'We are not responsible for delays, cancellations, or changes due to circumstances beyond our control, including weather, natural disasters, political unrest, or transportation issues.',
        'You are responsible for your personal belongings and travel documents throughout your journey.',
      ],
    },
    {
      title: 'Travel Behavior and Conduct',
      content: [
        'You must comply with all local laws, customs, and regulations of the destinations you visit.',
        'We reserve the right to refuse service or remove you from a tour if your behavior is disruptive, illegal, or poses a risk to others.',
        'In such cases, no refund will be provided, and you will be responsible for any additional costs incurred.',
        'You are responsible for any damage caused to property or injury to persons during your travel.',
      ],
    },
    {
      title: 'Changes and Modifications',
      content: [
        'We reserve the right to modify itineraries, accommodations, or services due to operational requirements, safety concerns, or circumstances beyond our control.',
        'We will make reasonable efforts to provide equivalent alternatives when changes are necessary.',
        'Price adjustments may apply if modifications result in significant changes to the package.',
        'You will be notified of any material changes as soon as possible.',
      ],
    },
    {
      title: 'Intellectual Property',
      content: [
        'All content on our website, including text, graphics, logos, images, and software, is the property of Balaji Tour & Travel or its licensors.',
        'You may not reproduce, distribute, modify, or create derivative works from our content without written permission.',
        'You may use our website for personal, non-commercial purposes only.',
      ],
    },
    {
      title: 'Dispute Resolution',
      content: [
        'Any disputes arising from these terms or our services will first be addressed through direct communication.',
        'If a resolution cannot be reached, disputes will be subject to the exclusive jurisdiction of the courts in Rohtak, Haryana, India.',
        'Indian law will govern these Terms and Conditions.',
      ],
    },
  ];

  return (
    <div className="pt-20">
      {/* Hero Section */}
      <section className="relative h-[50vh] flex items-center justify-center overflow-hidden bg-gradient-to-r from-primary-600 to-primary-800">
        <div className="absolute inset-0 opacity-20">
          <img
            src="https://images.unsplash.com/photo-1450101499163-c8848c66ca85?w=1920"
            alt="Terms and Conditions"
            className="w-full h-full object-cover"
          />
        </div>
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          className="relative z-10 text-center text-white px-4"
        >
          <Scale className="w-16 h-16 mx-auto mb-4" />
          <h1 className="text-5xl md:text-6xl font-bold mb-4">Terms & Conditions</h1>
          <p className="text-xl md:text-2xl text-gray-200 max-w-3xl mx-auto">
            Please read these terms carefully before using our services
          </p>
          <p className="text-sm text-gray-300 mt-4">
            Last updated: {new Date().toLocaleDateString('en-US', { year: 'numeric', month: 'long', day: 'numeric' })}
          </p>
        </motion.div>
      </section>

      {/* Introduction */}
      <section className="py-16 bg-white">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="prose prose-lg max-w-none"
          >
            <p className="text-gray-700 text-lg leading-relaxed mb-6">
              Welcome to <strong>Balaji Tour & Travel</strong>. These Terms and Conditions govern your use of our website and services. By accessing our website or using our services, you agree to comply with and be bound by these terms.
            </p>
            <p className="text-gray-700 text-lg leading-relaxed">
              These terms are designed to protect both you and us, ensuring a clear understanding of our respective rights and obligations. Please read them carefully and contact us if you have any questions.
            </p>
          </motion.div>
        </div>
      </section>

      {/* Main Content Sections */}
      <section className="py-16 bg-gray-50">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-12">
            {sections.map((section, index) => {
              const Icon = section.icon;
              return (
                <motion.div
                  key={index}
                  initial={{ opacity: 0, y: 20 }}
                  whileInView={{ opacity: 1, y: 0 }}
                  viewport={{ once: true }}
                  transition={{ delay: index * 0.1 }}
                  className="bg-white p-8 rounded-2xl shadow-lg border border-gray-100"
                >
                  <div className="flex items-center mb-6">
                    <div className="w-12 h-12 bg-primary-100 rounded-xl flex items-center justify-center mr-4">
                      <Icon className="w-6 h-6 text-primary-600" />
                    </div>
                    <h2 className="text-3xl font-bold text-gray-900">{section.title}</h2>
                  </div>
                  <ul className="space-y-4">
                    {section.content.map((item, itemIndex) => (
                      <li key={itemIndex} className="flex items-start">
                        <span className="text-primary-600 mr-3 mt-1">•</span>
                        <span className="text-gray-700 leading-relaxed">{item}</span>
                      </li>
                    ))}
                  </ul>
                </motion.div>
              );
            })}
          </div>
        </div>
      </section>

      {/* Additional Sections */}
      <section className="py-16 bg-white">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-8">
            {additionalSections.map((section, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                className="bg-gray-50 p-8 rounded-2xl border border-gray-200"
              >
                <h2 className="text-2xl font-bold text-gray-900 mb-4">{section.title}</h2>
                <ul className="space-y-3">
                  {section.content.map((item, itemIndex) => (
                    <li key={itemIndex} className="flex items-start">
                      <span className="text-primary-600 mr-3 mt-1">•</span>
                      <span className="text-gray-700 leading-relaxed">{item}</span>
                    </li>
                  ))}
                </ul>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Contact Section */}
      <section className="py-16 bg-primary-50">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="bg-white p-8 rounded-2xl border border-primary-100 shadow-lg"
          >
            <h2 className="text-2xl font-bold text-gray-900 mb-4">Questions About These Terms?</h2>
            <p className="text-gray-700 leading-relaxed mb-6">
              If you have any questions, concerns, or need clarification about these Terms and Conditions, please don't hesitate to contact us. We're here to help ensure you have a clear understanding of our policies.
            </p>
            <div className="space-y-2 text-gray-700">
              <p><strong>Email:</strong> balajitourandtravels2026@gmail.com</p>
              <p><strong>Phone:</strong> +91 9729849875</p>
              <p><strong>Address:</strong> Building No. 1, Maham Main Road, Near Rathi Auto Electric, Maham, Rohtak, Haryana - 124112, India</p>
            </div>
          </motion.div>
        </div>
      </section>
    </div>
  );
};

export default TermsAndConditions;

