#!/bin/bash

# Script to kill process using port 5000

echo "🔍 Finding process using port 5000..."

# Try to find the process
PID=$(sudo lsof -ti :5000 2>/dev/null)

if [ -z "$PID" ]; then
    echo "❌ No process found on port 5000"
    echo "💡 The port might be free now, or you need sudo access"
    exit 1
fi

echo "📌 Found process: PID $PID"
echo "🔄 Killing process..."

# Kill the process
sudo kill -9 $PID

if [ $? -eq 0 ]; then
    echo "✅ Successfully killed process $PID"
    echo "🚀 You can now start your server with: cd server && npm run dev"
else
    echo "❌ Failed to kill process. Try manually: sudo kill -9 $PID"
fi

