import mongoose from 'mongoose';

const connectDB = async () => {
  try {
    const mongoURI = process.env.MONGODB_URI || 'mongodb://localhost:27017/balaji-tour-travel';
    
    console.log('🔄 Connecting to MongoDB...');
    
    const conn = await mongoose.connect(mongoURI, {
      serverSelectionTimeoutMS: 5000, // Timeout after 5s instead of 30s
      socketTimeoutMS: 45000, // Close sockets after 45s of inactivity
    });

    console.log(`✅ MongoDB Connected: ${conn.connection.host}`);
    console.log(`📦 Database: ${conn.connection.name}`);
  } catch (error) {
    console.error(`❌ Error connecting to MongoDB: ${error.message}`);
    console.error('\n💡 Troubleshooting:');
    console.error('   1. Make sure MongoDB is running: sudo systemctl start mongod');
    console.error('   2. Or use MongoDB Atlas (cloud): Update MONGODB_URI in .env');
    console.error('   3. Check MONGODB_URI in server/.env file');
    process.exit(1);
  }
};

export default connectDB;

