import express from 'express';
import {
  createBooking,
  getBookings,
  getBookingById,
  updateBookingStatus,
  updatePaymentStatus,
} from '../controllers/bookingController.js';
import { protect, admin } from '../middleware/auth.js';

const router = express.Router();

// Public route
router.post('/', createBooking);

// Admin routes
router.get('/', protect, admin, getBookings);
router.get('/:id', protect, admin, getBookingById);
router.put('/:id/status', protect, admin, updateBookingStatus);
router.put('/payment', protect, admin, updatePaymentStatus);

export default router;

