import express from 'express';
import {
  createMessage,
  getMessages,
  getMessageById,
  updateMessageStatus,
  deleteMessage,
  getMessageStats,
} from '../controllers/messageController.js';
import { protect, admin } from '../middleware/auth.js';

const router = express.Router();

// Public route - for contact form
router.post('/', createMessage);

// Admin routes
router.get('/stats', protect, admin, getMessageStats);
router.get('/', protect, admin, getMessages);
router.get('/:id', protect, admin, getMessageById);
router.put('/:id/status', protect, admin, updateMessageStatus);
router.delete('/:id', protect, admin, deleteMessage);

export default router;

