import dotenv from 'dotenv';
import connectDB from '../config/db.js';
import User from '../models/User.js';
import bcrypt from 'bcryptjs';

dotenv.config();

const checkAdmin = async () => {
  try {
    await connectDB();
    
    const adminEmail = process.env.ADMIN_EMAIL || 'admin@balajitour.com';
    const adminPassword = process.env.ADMIN_PASSWORD || 'admin123';
    
    console.log('🔍 Checking admin user...');
    console.log('Looking for email:', adminEmail);
    console.log('');
    
    // Find admin user
    const admin = await User.findOne({ email: adminEmail });
    
    if (!admin) {
      console.log('❌ Admin user not found!');
      console.log('Creating admin user...');
      
      const hashedPassword = await bcrypt.hash(adminPassword, 12);
      const newAdmin = await User.create({
        email: adminEmail,
        password: hashedPassword,
        role: 'admin',
        name: 'Admin',
      });
      
      console.log('✅ Admin user created!');
      console.log('ID:', newAdmin._id);
      console.log('Email:', newAdmin.email);
      console.log('Role:', newAdmin.role);
    } else {
      console.log('✅ Admin user found!');
      console.log('ID:', admin._id);
      console.log('Email:', admin.email);
      console.log('Role:', admin.role);
      console.log('');
      
      // Test password
      console.log('🧪 Testing password...');
      const isMatch = await admin.comparePassword(adminPassword);
      
      if (isMatch) {
        console.log('✅ Password matches!');
      } else {
        console.log('❌ Password does NOT match!');
        console.log('Resetting password...');
        
        const hashedPassword = await bcrypt.hash(adminPassword, 12);
        admin.password = hashedPassword;
        admin.role = 'admin';
        await admin.save();
        
        console.log('✅ Password reset!');
      }
    }
    
    // List all users
    console.log('');
    console.log('📋 All users in database:');
    const allUsers = await User.find({});
    allUsers.forEach(user => {
      console.log(`  - ${user.email} (${user.role})`);
    });
    
    process.exit(0);
  } catch (error) {
    console.error('❌ Error:', error.message);
    process.exit(1);
  }
};

checkAdmin();

