import dotenv from 'dotenv';
import connectDB from '../config/db.js';
import User from '../models/User.js';
import bcrypt from 'bcryptjs';

dotenv.config();

const createAdmin = async () => {
  try {
    await connectDB();
    
    const adminEmail = process.env.ADMIN_EMAIL || 'admin@balajitour.com';
    const adminPassword = process.env.ADMIN_PASSWORD || 'admin123';
    
    console.log('🔍 Checking for admin user...');
    
    // Check if admin exists
    let admin = await User.findOne({ email: adminEmail });
    
    if (admin) {
      console.log('✅ Admin user already exists:', adminEmail);
      
      // Update password - set plain password, pre-save hook will hash it
      admin.password = adminPassword; // Plain password - will be hashed by pre-save hook
      admin.role = 'admin';
      await admin.save();
      
      console.log('✅ Admin password updated');
    } else {
      // Create new admin - pass plain password, pre-save hook will hash it
      admin = await User.create({
        email: adminEmail,
        password: adminPassword, // Plain password - will be hashed by pre-save hook
        role: 'admin',
        name: 'Admin',
      });
      
      console.log('✅ Admin user created:', adminEmail);
    }
    
    console.log('');
    console.log('📋 Admin Credentials:');
    console.log('   Email:', adminEmail);
    console.log('   Password:', adminPassword);
    console.log('');
    console.log('✅ Admin setup complete!');
    
    process.exit(0);
  } catch (error) {
    console.error('❌ Error creating admin:', error.message);
    process.exit(1);
  }
};

createAdmin();

