import dotenv from 'dotenv';
import connectDB from '../config/db.js';
import Package from '../models/Package.js';

dotenv.config();
connectDB();

const packages = [
  {
    title: 'Majestic Kashmir - Paradise on Earth',
    slug: 'majestic-kashmir-paradise-on-earth',
    description: 'Experience the breathtaking beauty of Kashmir with its pristine lakes, snow-capped mountains, and lush valleys. A perfect blend of nature, culture, and adventure awaits you in this paradise on earth.',
    shortDescription: 'Discover the stunning beauty of Kashmir with Dal Lake, Gulmarg, and Pahalgam.',
    price: 25999,
    originalPrice: 32999,
    duration: 5,
    location: 'Kashmir, India',
    category: 'Domestic',
    images: [
      'https://images.unsplash.com/photo-1578662996442-48f60103fc96?w=800',
      'https://images.unsplash.com/photo-1544966503-7cc5ac882d5f?w=800',
      'https://images.unsplash.com/photo-1578662996442-48f60103fc96?w=800',
    ],
    included: [
      'Hotel accommodation (4-star)',
      'Daily breakfast and dinner',
      'Airport transfers',
      'Sightseeing tours',
      'Shikara ride on Dal Lake',
      'Gondola ride in Gulmarg',
    ],
    excluded: [
      'Flight tickets',
      'Lunch',
      'Personal expenses',
      'Travel insurance',
    ],
    itinerary: [
      {
        day: 1,
        title: 'Arrival in Srinagar',
        description: 'Arrive at Srinagar airport, transfer to hotel. Evening Shikara ride on Dal Lake.',
      },
      {
        day: 2,
        title: 'Gulmarg Excursion',
        description: 'Full day trip to Gulmarg, enjoy Gondola ride and snow activities.',
      },
      {
        day: 3,
        title: 'Pahalgam Valley',
        description: 'Visit Pahalgam, explore Betaab Valley and Aru Valley.',
      },
      {
        day: 4,
        title: 'Srinagar Sightseeing',
        description: 'Visit Mughal Gardens, Shalimar Bagh, and local markets.',
      },
      {
        day: 5,
        title: 'Departure',
        description: 'Check out and transfer to airport for departure.',
      },
    ],
    highlights: [
      'Shikara ride on Dal Lake',
      'Gondola ride in Gulmarg',
      'Mughal Gardens visit',
      'Pahalgam Valley exploration',
    ],
    featured: true,
  },
  {
    title: 'Goa Beach Paradise - Sun, Sand & Fun',
    slug: 'goa-beach-paradise-sun-sand-fun',
    description: 'Relax on pristine beaches, enjoy water sports, explore Portuguese heritage, and experience vibrant nightlife in India\'s party capital.',
    shortDescription: 'Perfect beach getaway with water sports, heritage sites, and vibrant nightlife.',
    price: 18999,
    originalPrice: 24999,
    duration: 4,
    location: 'Goa, India',
    category: 'Domestic',
    images: [
      'https://images.unsplash.com/photo-1512343879784-a960bf40e7f2?w=800',
      'https://images.unsplash.com/photo-1559827260-dc66d52bef19?w=800',
      'https://images.unsplash.com/photo-1507525428034-b723cf961d3e?w=800',
    ],
    included: [
      'Beach resort accommodation',
      'Daily breakfast',
      'Water sports activities',
      'Heritage tour',
      'Airport transfers',
    ],
    excluded: [
      'Flight tickets',
      'Lunch and dinner',
      'Personal expenses',
      'Alcohol',
    ],
    itinerary: [
      {
        day: 1,
        title: 'Arrival in Goa',
        description: 'Arrive at Goa airport, transfer to beach resort. Evening at leisure.',
      },
      {
        day: 2,
        title: 'North Goa Beaches',
        description: 'Visit Calangute, Baga, and Anjuna beaches. Enjoy water sports.',
      },
      {
        day: 3,
        title: 'Heritage & Culture',
        description: 'Explore Old Goa churches, Spice Plantation, and local markets.',
      },
      {
        day: 4,
        title: 'South Goa & Departure',
        description: 'Visit Colva and Palolem beaches. Evening departure.',
      },
    ],
    highlights: [
      'Beach hopping',
      'Water sports',
      'Portuguese heritage',
      'Vibrant nightlife',
    ],
    featured: true,
  },
  {
    title: 'Royal Rajasthan - Land of Kings',
    slug: 'royal-rajasthan-land-of-kings',
    description: 'Explore the royal heritage of Rajasthan visiting magnificent palaces, forts, and experiencing the rich culture and traditions of the desert state.',
    shortDescription: 'Discover the royal palaces, forts, and rich culture of Rajasthan.',
    price: 34999,
    originalPrice: 42999,
    duration: 7,
    location: 'Rajasthan, India',
    category: 'Domestic',
    images: [
      'https://images.unsplash.com/photo-1524492412937-b28074a5d7da?w=800',
      'https://images.unsplash.com/photo-1564501049412-61c2a3083791?w=800',
      'https://images.unsplash.com/photo-1578662996442-48f60103fc96?w=800',
    ],
    included: [
      'Heritage hotel accommodation',
      'Daily breakfast and dinner',
      'AC vehicle for sightseeing',
      'Camel ride in Jaisalmer',
      'Elephant ride in Jaipur',
      'Cultural show',
    ],
    excluded: [
      'Flight/train tickets',
      'Lunch',
      'Monument entry fees',
      'Personal expenses',
    ],
    itinerary: [
      {
        day: 1,
        title: 'Arrival in Jaipur',
        description: 'Arrive in Jaipur, check-in. Evening visit to Hawa Mahal.',
      },
      {
        day: 2,
        title: 'Jaipur City Tour',
        description: 'Visit Amber Fort, City Palace, Jantar Mantar.',
      },
      {
        day: 3,
        title: 'Pushkar & Ajmer',
        description: 'Visit Pushkar Lake and Ajmer Sharif Dargah.',
      },
      {
        day: 4,
        title: 'Jodhpur - Blue City',
        description: 'Explore Mehrangarh Fort and Jaswant Thada.',
      },
      {
        day: 5,
        title: 'Jaisalmer - Golden City',
        description: 'Visit Jaisalmer Fort, Patwon Ki Haveli, and enjoy camel safari.',
      },
      {
        day: 6,
        title: 'Udaipur - City of Lakes',
        description: 'Visit City Palace, Jag Mandir, and enjoy boat ride on Lake Pichola.',
      },
      {
        day: 7,
        title: 'Departure',
        description: 'Check out and transfer to airport/railway station.',
      },
    ],
    highlights: [
      'Amber Fort & City Palace',
      'Camel safari in Jaisalmer',
      'Boat ride in Udaipur',
      'Royal heritage experience',
    ],
    featured: true,
  },
  {
    title: 'Swiss Alps Adventure - Europe',
    slug: 'swiss-alps-adventure-europe',
    description: 'Experience the breathtaking beauty of Swiss Alps with snow-capped peaks, pristine lakes, charming villages, and world-class hospitality.',
    shortDescription: 'Explore the stunning Swiss Alps with mountains, lakes, and charming villages.',
    price: 189999,
    originalPrice: 229999,
    duration: 6,
    location: 'Switzerland',
    category: 'International',
    images: [
      'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=800',
      'https://images.unsplash.com/photo-1515542622106-78bda8ba0e5b?w=800',
      'https://images.unsplash.com/photo-1501594907352-04cda38ebc29?w=800',
    ],
    included: [
      '4-star hotel accommodation',
      'Daily breakfast',
      'Swiss Travel Pass',
      'Jungfraujoch excursion',
      'Interlaken & Lucerne tours',
      'Airport transfers',
    ],
    excluded: [
      'International flights',
      'Lunch and dinner',
      'Visa fees',
      'Travel insurance',
    ],
    itinerary: [
      {
        day: 1,
        title: 'Arrival in Zurich',
        description: 'Arrive in Zurich, transfer to hotel. Evening city tour.',
      },
      {
        day: 2,
        title: 'Lucerne & Mount Titlis',
        description: 'Visit Lucerne, take cable car to Mount Titlis.',
      },
      {
        day: 3,
        title: 'Interlaken',
        description: 'Explore Interlaken, enjoy adventure activities.',
      },
      {
        day: 4,
        title: 'Jungfraujoch - Top of Europe',
        description: 'Full day excursion to Jungfraujoch, highest railway station.',
      },
      {
        day: 5,
        title: 'Grindelwald & Bern',
        description: 'Visit Grindelwald village and explore Bern city.',
      },
      {
        day: 6,
        title: 'Departure',
        description: 'Transfer to Zurich airport for departure.',
      },
    ],
    highlights: [
      'Jungfraujoch - Top of Europe',
      'Mount Titlis experience',
      'Swiss Travel Pass',
      'Alpine beauty',
    ],
    featured: true,
  },
  {
    title: 'Bali Island Paradise - Indonesia',
    slug: 'bali-island-paradise-indonesia',
    description: 'Discover the tropical paradise of Bali with stunning beaches, ancient temples, lush rice terraces, and world-class resorts.',
    shortDescription: 'Experience Bali\'s beaches, temples, rice terraces, and luxury resorts.',
    price: 49999,
    originalPrice: 64999,
    duration: 5,
    location: 'Bali, Indonesia',
    category: 'International',
    images: [
      'https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=800',
      'https://images.unsplash.com/photo-1518548419970-58e3b4079ab2?w=800',
      'https://images.unsplash.com/photo-1559827260-dc66d52bef19?w=800',
    ],
    included: [
      'Beach resort accommodation',
      'Daily breakfast',
      'Airport transfers',
      'Temple tours',
      'Rice terrace visit',
      'Water sports',
    ],
    excluded: [
      'International flights',
      'Lunch and dinner',
      'Visa fees',
      'Personal expenses',
    ],
    itinerary: [
      {
        day: 1,
        title: 'Arrival in Bali',
        description: 'Arrive at Denpasar airport, transfer to resort. Evening at leisure.',
      },
      {
        day: 2,
        title: 'Ubud & Rice Terraces',
        description: 'Visit Ubud, Tegalalang Rice Terraces, and Monkey Forest.',
      },
      {
        day: 3,
        title: 'Temple Tour',
        description: 'Visit Tanah Lot, Uluwatu Temple, and enjoy Kecak dance.',
      },
      {
        day: 4,
        title: 'Water Sports & Beach',
        description: 'Enjoy water sports at Nusa Dua, relax on beaches.',
      },
      {
        day: 5,
        title: 'Departure',
        description: 'Check out and transfer to airport.',
      },
    ],
    highlights: [
      'Ancient temples',
      'Rice terraces',
      'Water sports',
      'Beach relaxation',
    ],
    featured: false,
  },
  {
    title: 'Dubai Luxury Experience - UAE',
    slug: 'dubai-luxury-experience-uae',
    description: 'Indulge in the ultimate luxury experience in Dubai with world-class hotels, shopping, dining, and iconic attractions.',
    shortDescription: 'Luxury Dubai experience with Burj Khalifa, shopping, and desert safari.',
    price: 79999,
    originalPrice: 99999,
    duration: 4,
    location: 'Dubai, UAE',
    category: 'Luxury',
    images: [
      'https://images.unsplash.com/photo-1512453979798-5ea266f8880c?w=800',
      'https://images.unsplash.com/photo-1539650116574-75c0c6d73a6e?w=800',
      'https://images.unsplash.com/photo-1539650116574-75c0c6d73a6e?w=800',
    ],
    included: [
      '5-star hotel accommodation',
      'Daily breakfast',
      'Burj Khalifa 124th floor access',
      'Desert safari with dinner',
      'Dubai Mall & Aquarium',
      'Airport transfers',
    ],
    excluded: [
      'International flights',
      'Lunch',
      'Visa fees',
      'Shopping expenses',
    ],
    itinerary: [
      {
        day: 1,
        title: 'Arrival in Dubai',
        description: 'Arrive at Dubai airport, transfer to hotel. Evening Dubai Marina cruise.',
      },
      {
        day: 2,
        title: 'Burj Khalifa & Dubai Mall',
        description: 'Visit Burj Khalifa, Dubai Mall, and Dubai Aquarium.',
      },
      {
        day: 3,
        title: 'Desert Safari',
        description: 'Full day desert safari with dune bashing, camel ride, and BBQ dinner.',
      },
      {
        day: 4,
        title: 'Departure',
        description: 'Check out and transfer to airport.',
      },
    ],
    highlights: [
      'Burj Khalifa access',
      'Desert safari',
      'Luxury shopping',
      '5-star experience',
    ],
    featured: true,
  },
  {
    title: 'Manali Adventure - Himachal Pradesh',
    slug: 'manali-adventure-himachal-pradesh',
    description: 'Thrilling adventure in Manali with paragliding, river rafting, trekking, and snow activities in the beautiful Himalayas.',
    shortDescription: 'Adventure-packed Manali trip with paragliding, rafting, and trekking.',
    price: 22999,
    originalPrice: 28999,
    duration: 4,
    location: 'Manali, India',
    category: 'Adventure',
    images: [
      'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=800',
      'https://images.unsplash.com/photo-1512343879784-a960bf40e7f2?w=800',
      'https://images.unsplash.com/photo-1507525428034-b723cf961d3e?w=800',
    ],
    included: [
      'Hotel accommodation',
      'Daily breakfast and dinner',
      'Paragliding experience',
      'River rafting',
      'Trekking guide',
      'Transportation',
    ],
    excluded: [
      'Flight/train tickets',
      'Lunch',
      'Adventure activity equipment',
      'Personal expenses',
    ],
    itinerary: [
      {
        day: 1,
        title: 'Arrival in Manali',
        description: 'Arrive in Manali, check-in. Evening visit to Mall Road.',
      },
      {
        day: 2,
        title: 'Solang Valley & Adventure',
        description: 'Visit Solang Valley, enjoy paragliding and snow activities.',
      },
      {
        day: 3,
        title: 'River Rafting & Trekking',
        description: 'River rafting in Beas River, trekking to Jogini Falls.',
      },
      {
        day: 4,
        title: 'Rohtang Pass & Departure',
        description: 'Visit Rohtang Pass (subject to permit), departure.',
      },
    ],
    highlights: [
      'Paragliding',
      'River rafting',
      'Trekking',
      'Snow activities',
    ],
    featured: false,
  },
  {
    title: 'Maldives Honeymoon - Tropical Paradise',
    slug: 'maldives-honeymoon-tropical-paradise',
    description: 'Romantic honeymoon in the Maldives with overwater villas, crystal-clear waters, private beaches, and world-class spa experiences.',
    shortDescription: 'Romantic overwater villa experience in the pristine Maldives.',
    price: 149999,
    originalPrice: 199999,
    duration: 5,
    location: 'Maldives',
    category: 'Honeymoon',
    images: [
      'https://images.unsplash.com/photo-1512343879784-a960bf40e7f2?w=800',
      'https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=800',
      'https://images.unsplash.com/photo-1507525428034-b723cf961d3e?w=800',
    ],
    included: [
      'Overwater villa accommodation',
      'All meals included',
      'Airport seaplane transfer',
      'Snorkeling equipment',
      'Spa session',
      'Sunset cruise',
    ],
    excluded: [
      'International flights',
      'Alcohol',
      'Water sports (extra)',
      'Personal expenses',
    ],
    itinerary: [
      {
        day: 1,
        title: 'Arrival in Maldives',
        description: 'Seaplane transfer to resort, check-in to overwater villa.',
      },
      {
        day: 2,
        title: 'Beach & Water Activities',
        description: 'Snorkeling, beach relaxation, and water sports.',
      },
      {
        day: 3,
        title: 'Island Hopping',
        description: 'Visit nearby islands, local culture experience.',
      },
      {
        day: 4,
        title: 'Spa & Relaxation',
        description: 'Couple spa session, sunset cruise, romantic dinner.',
      },
      {
        day: 5,
        title: 'Departure',
        description: 'Seaplane transfer to airport for departure.',
      },
    ],
    highlights: [
      'Overwater villa',
      'Crystal-clear waters',
      'Romantic dinners',
      'Spa experience',
    ],
    featured: true,
  },
  {
    title: 'Kerala Backwaters - God\'s Own Country',
    slug: 'kerala-backwaters-gods-own-country',
    description: 'Experience the serene backwaters of Kerala with houseboat stays, tea plantations, wildlife sanctuaries, and Ayurvedic wellness.',
    shortDescription: 'Serene Kerala backwaters with houseboat, tea gardens, and Ayurveda.',
    price: 27999,
    originalPrice: 34999,
    duration: 5,
    location: 'Kerala, India',
    category: 'Family',
    images: [
      'https://images.unsplash.com/photo-1507525428034-b723cf961d3e?w=800',
      'https://images.unsplash.com/photo-1512343879784-a960bf40e7f2?w=800',
      'https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=800',
    ],
    included: [
      'Hotel & houseboat accommodation',
      'Daily breakfast and dinner',
      'Houseboat cruise',
      'Tea plantation tour',
      'Ayurvedic spa session',
      'Transportation',
    ],
    excluded: [
      'Flight/train tickets',
      'Lunch',
      'Personal expenses',
      'Extra activities',
    ],
    itinerary: [
      {
        day: 1,
        title: 'Arrival in Cochin',
        description: 'Arrive in Cochin, city tour, check-in to hotel.',
      },
      {
        day: 2,
        title: 'Munnar - Tea Gardens',
        description: 'Drive to Munnar, visit tea plantations and waterfalls.',
      },
      {
        day: 3,
        title: 'Thekkady - Wildlife',
        description: 'Visit Periyar Wildlife Sanctuary, spice plantation.',
      },
      {
        day: 4,
        title: 'Alleppey - Houseboat',
        description: 'Houseboat cruise through backwaters, overnight stay.',
      },
      {
        day: 5,
        title: 'Departure',
        description: 'Check out and transfer to Cochin airport.',
      },
    ],
    highlights: [
      'Houseboat cruise',
      'Tea plantations',
      'Wildlife sanctuary',
      'Ayurvedic spa',
    ],
    featured: true,
  },
  {
    title: 'Singapore & Malaysia - Twin Delight',
    slug: 'singapore-malaysia-twin-delight',
    description: 'Explore the modern marvels of Singapore and the cultural richness of Malaysia in one amazing journey.',
    shortDescription: 'Explore Singapore\'s modern attractions and Malaysia\'s cultural heritage.',
    price: 89999,
    originalPrice: 114999,
    duration: 6,
    location: 'Singapore & Malaysia',
    category: 'International',
    images: [
      'https://images.unsplash.com/photo-1525625293386-3f8f99389edd?w=800',
      'https://images.unsplash.com/photo-1512453979798-5ea266f8880c?w=800',
      'https://images.unsplash.com/photo-1539650116574-75c0c6d73a6e?w=800',
    ],
    included: [
      '4-star hotel accommodation',
      'Daily breakfast',
      'Singapore city tour',
      'Sentosa Island access',
      'KL city tour',
      'Petronas Towers visit',
      'Airport transfers',
    ],
    excluded: [
      'International flights',
      'Lunch and dinner',
      'Visa fees',
      'Personal expenses',
    ],
    itinerary: [
      {
        day: 1,
        title: 'Arrival in Singapore',
        description: 'Arrive in Singapore, city tour, check-in to hotel.',
      },
      {
        day: 2,
        title: 'Singapore Attractions',
        description: 'Visit Marina Bay, Gardens by the Bay, Sentosa Island.',
      },
      {
        day: 3,
        title: 'Travel to Kuala Lumpur',
        description: 'Travel to KL, check-in, evening city tour.',
      },
      {
        day: 4,
        title: 'KL City Tour',
        description: 'Visit Petronas Towers, Batu Caves, KL Tower.',
      },
      {
        day: 5,
        title: 'Genting Highlands',
        description: 'Day trip to Genting Highlands, theme park.',
      },
      {
        day: 6,
        title: 'Departure',
        description: 'Transfer to KL airport for departure.',
      },
    ],
    highlights: [
      'Marina Bay Singapore',
      'Sentosa Island',
      'Petronas Towers',
      'Genting Highlands',
    ],
    featured: false,
  },
];

const seedPackages = async () => {
  try {
    await Package.deleteMany({});
    await Package.insertMany(packages);
    console.log('✅ 10 Tour packages seeded successfully!');
    process.exit(0);
  } catch (error) {
    console.error('❌ Error seeding packages:', error);
    process.exit(1);
  }
};

seedPackages();

