#!/bin/bash

# Script to create .env files for server and client

echo "🔧 Setting up environment files..."
echo ""

# Server .env
SERVER_ENV="server/.env"
if [ ! -f "$SERVER_ENV" ]; then
    echo "📝 Creating $SERVER_ENV..."
    cat > "$SERVER_ENV" << 'EOF'
# Server Configuration
PORT=5000
NODE_ENV=development

# MongoDB
# For local MongoDB:
MONGODB_URI=mongodb://localhost:27017/balaji-tour-travel

# For MongoDB Atlas (cloud), use:
# MONGODB_URI=mongodb+srv://username:password@cluster0.xxxxx.mongodb.net/balaji-tour-travel?retryWrites=true&w=majority

# JWT Secret
JWT_SECRET=your-super-secret-jwt-key-change-in-production-min-32-chars-long

# Admin Default Credentials
ADMIN_EMAIL=admin@balajitour.com
ADMIN_PASSWORD=admin123

# Veegah Payment Gateway
VEEGAH_MERCHANT_ID=your_merchant_id
VEEGAH_API_KEY=your_api_key
VEEGAH_SECRET_KEY=your_secret_key
VEEGAH_PAYMENT_URL=https://api.veegah.com/payment
VEEGAH_CALLBACK_URL=http://localhost:5000/api/payments/callback

# Frontend URL
CLIENT_URL=http://localhost:5173
EOF
    echo "✅ Created $SERVER_ENV"
    echo "⚠️  Please update MONGODB_URI if using MongoDB Atlas"
else
    echo "ℹ️  $SERVER_ENV already exists, skipping..."
fi

# Client .env
CLIENT_ENV="client/.env"
if [ ! -f "$CLIENT_ENV" ]; then
    echo "📝 Creating $CLIENT_ENV..."
    cat > "$CLIENT_ENV" << 'EOF'
VITE_API_URL=http://localhost:5000/api
EOF
    echo "✅ Created $CLIENT_ENV"
else
    echo "ℹ️  $CLIENT_ENV already exists, skipping..."
fi

echo ""
echo "✅ Environment files setup complete!"
echo ""
echo "📖 Next steps:"
echo "   1. Install MongoDB (see MONGODB_SETUP.md)"
echo "   2. Update MONGODB_URI in server/.env if needed"
echo "   3. Start MongoDB: sudo systemctl start mongod"
echo "   4. Seed database: cd server && npm run seed"
echo "   5. Start server: cd server && npm run dev"

